@extends('layouts.shop')

@section('title', 'Choosing Your Yarn - Yarn Store')
@section('meta_description', 'Expert guidance on selecting the perfect yarn for your project. Learn about fiber types, weights, and how to match yarn to patterns.')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('guides.care') }}">Guides</a></li>
                <li class="breadcrumb-item active">Choosing Yarn</li>
            </ol>
        </nav>
        <h1 class="fw-bold mb-0">Choosing the Perfect Yarn</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="ys-card p-4 mb-4">
                <p class="lead">Selecting the right yarn is crucial for project success. This guide helps you make informed decisions based on your needs.</p>

                <h3 class="fw-bold mt-4 mb-3">Understanding Yarn Weights</h3>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Weight</th>
                                <th>Category</th>
                                <th>Best For</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>0-1</td>
                                <td>Lace/Fingering</td>
                                <td>Lace shawls, socks, delicate garments</td>
                            </tr>
                            <tr>
                                <td>2</td>
                                <td>Sport</td>
                                <td>Baby items, lightweight garments</td>
                            </tr>
                            <tr>
                                <td>3</td>
                                <td>DK/Light Worsted</td>
                                <td>Sweaters, scarves, most projects</td>
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>Worsted/Aran</td>
                                <td>Afghans, sweaters, winter accessories</td>
                            </tr>
                            <tr>
                                <td>5</td>
                                <td>Chunky</td>
                                <td>Thick scarves, blankets, quick projects</td>
                            </tr>
                            <tr>
                                <td>6-7</td>
                                <td>Super Bulky</td>
                                <td>Very warm items, statement pieces</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <h3 class="fw-bold mt-4 mb-3">Fiber Types</h3>
                
                <h5 class="fw-bold mt-3">Wool</h5>
                <p><strong>Pros:</strong> Warm, elastic, durable, breathable<br>
                <strong>Best for:</strong> Sweaters, socks, winter accessories<br>
                <strong>Care:</strong> Hand wash or gentle machine wash</p>

                <h5 class="fw-bold mt-3">Cotton</h5>
                <p><strong>Pros:</strong> Cool, absorbent, machine washable, hypoallergenic<br>
                <strong>Best for:</strong> Summer garments, dishcloths, baby items<br>
                <strong>Care:</strong> Machine washable, may shrink</p>

                <h5 class="fw-bold mt-3">Alpaca</h5>
                <p><strong>Pros:</strong> Very warm, soft, hypoallergenic, luxurious<br>
                <strong>Best for:</strong> Special garments, warm accessories<br>
                <strong>Care:</strong> Hand wash, may stretch when wet</p>

                <h5 class="fw-bold mt-3">Acrylic</h5>
                <p><strong>Pros:</strong> Budget-friendly, machine washable, colorfast<br>
                <strong>Best for:</strong> Afghans, practice projects, children's items<br>
                <strong>Care:</strong> Machine washable and dryable</p>

                <h5 class="fw-bold mt-3">Silk</h5>
                <p><strong>Pros:</strong> Luxurious, strong, beautiful drape<br>
                <strong>Best for:</strong> Special occasion garments, shawls<br>
                <strong>Care:</strong> Hand wash, requires special care</p>

                <h3 class="fw-bold mt-4 mb-3">Matching Yarn to Project</h3>
                
                <h5 class="fw-bold mt-3">For Garments</h5>
                <ul>
                    <li>Consider drape and weight</li>
                    <li>Think about care requirements</li>
                    <li>Check gauge carefully</li>
                    <li>Buy extra for matching dye lots</li>
                </ul>

                <h5 class="fw-bold mt-3">For Home Decor</h5>
                <ul>
                    <li>Prioritize durability</li>
                    <li>Choose washable fibers</li>
                    <li>Consider color fastness</li>
                </ul>

                <h5 class="fw-bold mt-3">For Baby Items</h5>
                <ul>
                    <li>Choose soft, non-irritating fibers</li>
                    <li>Ensure machine washability</li>
                    <li>Avoid fuzzy yarns (choking hazard)</li>
                    <li>Consider organic options</li>
                </ul>

                <h3 class="fw-bold mt-4 mb-3">How Much Yarn Do I Need?</h3>
                <p>General guidelines:</p>
                <ul>
                    <li>Always buy more than you think you'll need</li>
                    <li>Buy from the same dye lot</li>
                    <li>Check pattern requirements carefully</li>
                    <li>Keep labels for reference</li>
                </ul>

                <h3 class="fw-bold mt-4 mb-3">Reading Yarn Labels</h3>
                <p>Important information on yarn labels:</p>
                <ul>
                    <li><strong>Fiber content:</strong> What the yarn is made from</li>
                    <li><strong>Weight/Thickness:</strong> Standard weight category</li>
                    <li><strong>Yardage:</strong> Length of yarn in the ball/skein</li>
                    <li><strong>Dye lot:</strong> For color matching</li>
                    <li><strong>Care instructions:</strong> How to wash and dry</li>
                    <li><strong>Recommended needle size:</strong> Starting point for gauge</li>
                    <li><strong>Gauge information:</strong> Expected stitches/rows per inch</li>
                </ul>
            </div>

            <div class="row g-3 mt-4">
                <div class="col-md-6">
                    <div class="p-4 h-100" style="background-color: var(--ys-bg-section); border-radius: 0.5rem;">
                        <h5 class="fw-bold mb-3">Still Unsure?</h5>
                        <p class="mb-3">Browse our collection by category to find inspiration</p>
                        <a href="{{ route('shop.all') }}" class="btn btn-ys-primary">Browse Yarns</a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="p-4 h-100" style="background-color: var(--ys-bg-section); border-radius: 0.5rem;">
                        <h5 class="fw-bold mb-3">Need Expert Advice?</h5>
                        <p class="mb-3">Our team is here to help you choose</p>
                        <a href="{{ route('contact') }}" class="btn btn-outline-primary">Contact Us</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

