<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('order_number')->unique();
            $table->enum('status', ['pending', 'confirmed', 'processing', 'shipped', 'delivered', 'cancelled'])->default('pending');
            $table->decimal('initial_subtotal', 10, 2); // Initial estimated subtotal
            $table->decimal('initial_tax_amount', 10, 2)->default(0); // Initial estimated tax
            $table->decimal('initial_shipping_amount', 10, 2)->default(0); // Initial estimated shipping
            $table->decimal('initial_total_amount', 10, 2); // Initial estimated total
            
            $table->decimal('invoiced_subtotal', 10, 2)->nullable(); // Final invoiced subtotal
            $table->decimal('invoiced_tax_amount', 10, 2)->default(0); // Final invoiced tax
            $table->decimal('invoiced_shipping_amount', 10, 2)->default(0); // Final invoiced shipping
            $table->decimal('invoiced_total_amount', 10, 2)->nullable(); // Final invoiced total
            
            $table->string('currency', 3)->default('GBP');
            $table->string('zoho_invoice_number')->nullable(); // Zoho Books invoice number
            $table->string('supplier_invoice_number')->nullable(); // Supplier invoice number
            $table->text('notes')->nullable();
            $table->timestamp('shipped_at')->nullable();
            $table->timestamp('delivered_at')->nullable();
            $table->string('tracking_number')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
