<div class="max-w-4xl mx-auto py-6">
    <div class="bg-white shadow-sm rounded-lg">
        <!-- Header -->
        <div class="px-6 py-4 border-b border-gray-200">
            <h2 class="text-xl font-semibold text-gray-900">Consent Management</h2>
            <p class="mt-1 text-sm text-gray-600">
                Manage your privacy and data processing consents. You can accept, revoke, or review your consents at any time.
            </p>
        </div>

        <!-- Consents List -->
        <div class="p-6">
            @if($consents->isEmpty())
                <div class="text-center py-12">
                    <div class="mx-auto h-12 w-12 text-gray-400">
                        <svg class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                    </div>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No consents found</h3>
                    <p class="mt-1 text-sm text-gray-500">You don't have any consents to manage at this time.</p>
                </div>
            @else
                @foreach($consents as $type => $typeConsents)
                    <div class="mb-8">
                        <h3 class="text-lg font-medium text-gray-900 mb-4 capitalize">
                            {{ str_replace('_', ' ', $type) }}
                        </h3>
                        
                        <div class="space-y-4">
                            @foreach($typeConsents as $consent)
                                <div class="bg-gray-50 rounded-lg p-4 border border-gray-200">
                                    <div class="flex items-start justify-between">
                                        <div class="flex-1">
                                            <div class="flex items-center space-x-3">
                                                <h4 class="text-sm font-medium text-gray-900">
                                                    {{ $consent->description }}
                                                </h4>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $this->getConsentStatusColor($consent) }}">
                                                    {{ $this->getConsentStatus($consent) }}
                                                </span>
                                            </div>
                                            
                                            <div class="mt-2 text-sm text-gray-600">
                                                <p><strong>Version:</strong> {{ $consent->version }}</p>
                                                @if($consent->accepted_at)
                                                    <p><strong>Accepted:</strong> {{ $consent->accepted_at->format('M j, Y \a\t g:i A') }}</p>
                                                @endif
                                                @if($consent->expires_at)
                                                    <p><strong>Expires:</strong> {{ $consent->expires_at->format('M j, Y \a\t g:i A') }}</p>
                                                @endif
                                                @if($consent->created_at)
                                                    <p><strong>Created:</strong> {{ $consent->created_at->format('M j, Y \a\t g:i A') }}</p>
                                                @endif
                                            </div>
                                        </div>
                                        
                                        <div class="ml-4 flex-shrink-0">
                                            @if(!$consent->is_accepted)
                                                <button
                                                    wire:click="acceptConsent({{ $consent->id }})"
                                                    class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200"
                                                >
                                                    <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                                    </svg>
                                                    Accept
                                                </button>
                                            @elseif($consent->isActive())
                                                <button
                                                    wire:click="openRevokeModal({{ $consent->id }})"
                                                    class="inline-flex items-center px-3 py-2 border border-gray-300 text-sm leading-4 font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transition-colors duration-200"
                                                >
                                                    <svg class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                    </svg>
                                                    Revoke
                                                </button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>

    <!-- Revoke Confirmation Modal -->
    @if($showRevokeModal)
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity z-50"></div>
        
        <div class="fixed inset-0 z-50 overflow-y-auto">
            <div class="flex min-h-full items-end justify-center p-4 text-center sm:items-center sm:p-0">
                <div class="relative transform overflow-hidden rounded-lg bg-white px-4 pb-4 pt-5 text-left shadow-xl transition-all sm:my-8 sm:w-full sm:max-w-lg sm:p-6">
                    <div class="sm:flex sm:items-start">
                        <div class="mx-auto flex h-12 w-12 flex-shrink-0 items-center justify-center rounded-full bg-red-100 sm:mx-0 sm:h-10 sm:w-10">
                            <svg class="h-6 w-6 text-red-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z" />
                            </svg>
                        </div>
                        <div class="mt-3 text-center sm:ml-4 sm:mt-0 sm:text-left">
                            <h3 class="text-base font-semibold leading-6 text-gray-900">
                                Revoke Consent
                            </h3>
                            <div class="mt-2">
                                <p class="text-sm text-gray-500">
                                    Are you sure you want to revoke your consent for "{{ $consentToRevoke->description }}"? 
                                    This action cannot be undone and may affect your access to certain features.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="mt-5 sm:mt-4 sm:flex sm:flex-row-reverse">
                        <button
                            type="button"
                            wire:click="confirmRevoke"
                            class="inline-flex w-full justify-center rounded-md bg-red-600 px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-red-500 sm:ml-3 sm:w-auto transition-colors duration-200"
                        >
                            Revoke Consent
                        </button>
                        <button
                            type="button"
                            wire:click="closeRevokeModal"
                            class="mt-3 inline-flex w-full justify-center rounded-md bg-white px-3 py-2 text-sm font-semibold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50 sm:mt-0 sm:w-auto transition-colors duration-200"
                        >
                            Cancel
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
