<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Wellness Library') }}
            </h2>
            <div class="flex items-center space-x-4">
                <form action="{{ route('library.search') }}" method="GET" class="flex">
                    <input type="text" 
                           name="q" 
                           placeholder="Search wellness content..." 
                           class="rounded-l-lg border-gray-300 focus:border-indigo-500 focus:ring-indigo-500"
                           value="{{ request('search') }}">
                    <button type="submit" 
                            class="bg-indigo-600 text-white px-4 py-2 rounded-r-lg hover:bg-indigo-700 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                    </button>
                </form>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Hero Section -->
            <div class="bg-gradient-to-r from-indigo-500 to-purple-600 rounded-lg shadow-lg mb-8">
                <div class="px-6 py-8 text-white">
                    <h1 class="text-3xl font-bold mb-2">Discover Your Wellness Path</h1>
                    <p class="text-indigo-100 text-lg">Explore guided sessions, meditation tracks, and wellness resources tailored to your journey.</p>
                </div>
            </div>

            <!-- Categories Grid -->
            <div class="mb-12">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Wellness Categories</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($categories as $category)
                        <a href="{{ route('library.category', $category->slug) }}" 
                           class="group block bg-white rounded-lg shadow-sm border border-gray-200 hover:shadow-md transition-shadow">
                            <div class="p-6">
                                <div class="flex items-center justify-between mb-4">
                                    <div class="w-12 h-12 bg-indigo-100 rounded-lg flex items-center justify-center group-hover:bg-indigo-200 transition-colors">
                                        <svg class="w-6 h-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                                        </svg>
                                    </div>
                                    <span class="text-sm text-gray-500">{{ $category->tracks_count ?? 0 }} tracks</span>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2 group-hover:text-indigo-600 transition-colors">
                                    {{ $category->name }}
                                </h3>
                                <p class="text-gray-600 text-sm">{{ $category->description }}</p>
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>

            <!-- Popular Tracks -->
            <div class="mb-12">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Popular This Week</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($popularTracks as $track)
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden hover:shadow-md transition-shadow">
                            <div class="p-6">
                                <div class="flex items-center justify-between mb-3">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-indigo-100 text-indigo-800">
                                        {{ $track->category->name }}
                                    </span>
                                    <span class="text-sm text-gray-500">{{ $track->duration }} min</span>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">{{ $track->title }}</h3>
                                <p class="text-gray-600 text-sm mb-4">{{ Str::limit($track->description, 100) }}</p>
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center space-x-2">
                                        <svg class="w-4 h-4 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                        </svg>
                                        <span class="text-sm text-gray-600">{{ number_format($track->rating, 1) }}</span>
                                    </div>
                                    <a href="{{ route('library.track', $track->slug) }}" 
                                       class="text-indigo-600 hover:text-indigo-700 text-sm font-medium">
                                        Listen →
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Recent Additions -->
            <div class="mb-12">
                <h2 class="text-2xl font-bold text-gray-900 mb-6">Recently Added</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($recentTracks as $track)
                        <div class="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden hover:shadow-md transition-shadow">
                            <div class="p-6">
                                <div class="flex items-center justify-between mb-3">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        New
                                    </span>
                                    <span class="text-sm text-gray-500">{{ $track->duration }} min</span>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-900 mb-2">{{ $track->title }}</h3>
                                <p class="text-gray-600 text-sm mb-4">{{ Str::limit($track->description, 100) }}</p>
                                <div class="flex items-center justify-between">
                                    <span class="text-sm text-gray-500">{{ $track->category->name }}</span>
                                    <a href="{{ route('library.track', $track->slug) }}" 
                                       class="text-indigo-600 hover:text-indigo-700 text-sm font-medium">
                                        Listen →
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Browse All Content -->
            <div class="text-center">
                <h2 class="text-2xl font-bold text-gray-900 mb-4">Can't Find What You're Looking For?</h2>
                <p class="text-gray-600 mb-6">Browse our complete collection of wellness content and discover new ways to enhance your well-being.</p>
                <a href="#" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-lg text-white bg-indigo-600 hover:bg-indigo-700 transition-colors">
                    Browse All Content
                </a>
            </div>
        </div>
    </div>
</x-app-layout>
