<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomSession extends Model
{
    use HasFactory;

    protected $fillable = [
        'request_id', 'title', 'duration_sec', 'audio_path', 'transcript_path', 'model_meta',
    ];

    protected $casts = [
        'model_meta' => 'array',
    ];

    public function request()
    {
        return $this->belongsTo(CustomRequest::class, 'request_id');
    }
}


