<?php

use App\Models\ShipmentLine;
use App\Services\ZohoService;
use App\Http\Livewire\YC\YCAdmin;
use App\Http\Livewire\Imports\Asos;
use App\Http\Livewire\Logs\StyleLog;
use App\Http\Livewire\Logs\ViewLogs;
use App\Http\Livewire\Imports\Orders;
use App\Http\Livewire\Logs\OrderLogs;
use Illuminate\Support\Facades\Route;
use App\Http\Livewire\YC\YCOrdersList;
use App\Http\Controllers\SSQuickUpdate;
use App\Http\Livewire\Finance\Cashflow;
use App\Http\Livewire\Finance\ProdLookup;
use App\Http\Livewire\Orders\YarnOrderPO;
use App\Http\Livewire\Admin\Yarn\YarnView;
use App\Http\Livewire\Designs\DesignsList;
use App\Http\Livewire\Imports\AiOrdersKwa;
use App\Http\Controllers\InvoiceController;
use App\Http\Livewire\Admin\Sizes\SizeView;
use App\Http\Livewire\Imports\AiOrdersAsos;
use App\Http\Livewire\Management\UsersList;

use App\Http\Controllers\ZohoAuthController;
use App\Http\Livewire\Designs\DesignsManage;
use App\Http\Livewire\Reports\Orders\CPTest;
use App\Http\Livewire\Reports\Orders\SSTest;
use App\Http\Controllers\GeminiApiController;
use App\Http\Livewire\Admin\Counts\CountView;
use App\Http\Livewire\Admin\Gauges\GaugeView;

use App\Http\Livewire\Orders\AccessoryOrders;
use App\Http\Livewire\UserDash\UserDashboard;
use App\Http\Livewire\Sales\Orders\OrdersList;
use App\Http\Livewire\Admin\Seasons\SeasonView;
use App\Http\Livewire\Finance\SamplesInvoicing;
use App\Http\Livewire\Imports\OrdersCommission;


use App\Http\Livewire\Sales\Pricing\KwaPricing;
use App\Http\Livewire\Sales\Pricing\PricingSheet;
use App\Http\Livewire\Development\Samples\BulkAdd;
use App\Http\Livewire\Admin\Customers\CustomerView;

use App\Http\Livewire\Admin\Materials\MaterialView;
use App\Http\Livewire\Admin\Suppliers\SupplierView;
use App\Http\Livewire\Development\Styles\StylesList;
// use App\Http\Livewire\Sales\Pricing\PricingSheetDev; // removed per latest changes
use App\Http\Livewire\Finance\Cashflow\WhCashflowNew;
use App\Http\Livewire\Production\Yarn\YarnOrdersView;
use App\Http\Livewire\Development\Samples\SamplesList;
use App\Http\Livewire\Development\Styles\StyleEditNew;
use App\Http\Livewire\Development\Styles\StylesManage;
use App\Http\Livewire\Finance\Cashflow\WhCashflowList;
use App\Http\Livewire\Production\Reports\CriticalPath;
use App\Http\Livewire\Admin\Departments\DepartmentView;
use App\Http\Livewire\Admin\InvoiceLayouts\InvoiceView;
use App\Http\Livewire\Admin\SampleTypes\SampleTypeView;
use App\Http\Livewire\Finance\Cashflow\WhCashflowPivot;
use App\Http\Livewire\Finance\Cashflow\WhCashflowPivotNew;
use App\Http\Livewire\Production\Reports\FactoryOrders;
use App\Http\Livewire\Admin\Accessories\AccessoriesEdit;
use App\Http\Livewire\Development\Samples\SamplesManage;
use App\Http\Livewire\Development\Reports\StylesOverview;
use App\Http\Livewire\Production\Reports\CriticalPathNew;
use App\Http\Livewire\Production\Shipments\ShipmentsView;
use App\Http\Livewire\Sales\Pricing\CustomerPricingSheet;
use App\Http\Livewire\Production\Reports\AsosCriticalPath;
use App\Http\Livewire\Production\Reports\SalesValuesExfty;
use App\Http\Livewire\Production\Reports\ShipmentSchedule;
use App\Http\Livewire\Production\Reports\CriticalPathTesting;
use App\Http\Livewire\Finance\CommissionCashflow\CoCashflowList;
use App\Http\Livewire\Finance\CommissionCashflow\CoCashflowPivot;
use App\Http\Livewire\Production\Reports\CommissionSalesValuesExfty;
use App\Http\Livewire\Production\Reports\CommissionShipmentSchedule;
use App\Http\Livewire\Production\Reports\ShipmentScheduleExportFactory;
use App\Http\Livewire\Production\Reports\CommissionShipmentScheduleTest;
use App\Http\Livewire\Development\Reports\StylesOverviewBeta;
use App\Http\Controllers\CashflowExportController;
use App\Http\Livewire\Production\OrderVsDrop;
use App\Http\Livewire\Imports\PLMabliImport;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified'
])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');
    Route::get('/', function () {
        return view('dashboard');
    })->name('core');

    Route::get('/designs', DesignsList::class)->name('designs');

    Route::get('/styles', StylesList::class)->name('styles');
    Route::get('/stylesedit/{styleId}', StyleEditNew::class)->name('stylesedit');
    Route::get('/samples', SamplesList::class)->name('samples');
    Route::get('/samplesbulk', BulkAdd::class)->name('samplesbulk');
    Route::get('/stylesoverview', StylesOverview::class)->name('stylesoverview');
    Route::get('/stylesoverviewbeta', StylesOverviewBeta::class)->name('stylesoverviewbeta');

    Route::get('/pricing', PricingSheet::class)->name('pricing');
    Route::get('/kwapricing', KwaPricing::class)->name('kwapricing');
    // Route::get('/pricingdev', PricingSheetDev::class)->name('pricingdev');
    Route::get('/pricingcustomerprint/{array}', CustomerPricingSheet::class)->name('pricingcustomerprint');
    Route::get('/orders', OrdersList::class)->name('orders');

    Route::get('/yarnpo', YarnOrdersView::class)->name('yarnpo');
    Route::get('/shipments', ShipmentsView::class)->name('shipments');
    Route::get('/criticalpath', CriticalPath::class)->name('criticalpath');
    Route::get('/criticalpathnew', CriticalPathNew::class)->name('criticalpathnew');
    Route::get('/asoscriticalpath', AsosCriticalPath::class)->name('asoscriticalpath');
    Route::get('factorypo', FactoryOrders::class)->name('factorypo');
    Route::get('/shipmentscheduleexportfactory/{array}', ShipmentScheduleExportFactory::class)->name('shipmentscheduleexportfactory');
    Route::get('/shipmentschedule', ShipmentSchedule::class)->name('shipmentschedule');

    Route::get('/ordervsdrop', OrderVsDrop::class)->name('ordervsdrop');

    // Route::get('/reports/orders/commissionshipmentscheduletest', CommissionShipmentScheduleTest::class)->name('commissionshipmentscheduletest');
    Route::get('/commissionshipmentschedule', CommissionShipmentSchedule::class)->name('commissionshipmentschedule');
    Route::get('/salesvalues', SalesValuesExfty::class)->name('salesvalues');
    Route::get('/commissionsalesvalues', CommissionSalesValuesExfty::class)->name('commissionsalesvalues');

    Route::get('/customers', CustomerView::class)->name('customers');
    Route::get('/suppliers', SupplierView::class)->name('suppliers');
    Route::get('/departments', DepartmentView::class)->name('departments');
    Route::get('/seasons', SeasonView::class)->name('seasons');
    Route::get('/yarns', YarnView::class)->name('yarns');
    Route::get('/materials', MaterialView::class)->name('materials');
    Route::get('/counts', CountView::class)->name('counts');
    Route::get('/sampletypes', SampleTypeView::class)->name('sampletypes');
    Route::get('/sizes', SizeView::class)->name('sizes');
    Route::get('/gauges', GaugeView::class)->name('gauges');
    Route::get('/invoicelayouts', InvoiceView::class)->name('invoicelayouts');

    Route::get('/samplesinvoice', SamplesInvoicing::class)->name('samplesinvoice');
    Route::get('/samplesinvoicenew', \App\Http\Livewire\Finance\SamplesInvoicingNew::class)->name('samplesinvoicenew');
    Route::get('/cashflow/cashflowlist', WhCashflowList::class)->name('cashflow');
    Route::get('/cashflow/cashflowpivot/{cashflowId}', WhCashflowPivotNew::class)->name('cashflowpivot');
    Route::get('/cashflow/cocashflow', CoCashflowList::class)->name('cocashflow');
    Route::get('/cashflow/cocashflowpivot/{cashflowId}', CoCashflowPivot::class)->name('cocashflowpivot');
    Route::match(['GET','POST'],'/cashflow/export-pivot-xlsx', [CashflowExportController::class, 'exportPivot'])->name('cashflow.exportPivot');
    Route::get('/prodlookup', ProdLookup::class)->name('prodlookup');

    Route::get('/userdash', UserDashboard::class)->name('userdash');


    Route::get('/importasos', App\Http\Livewire\Imports\Asos::class)->name('importasos');
    Route::get('/importorders', App\Http\Livewire\Imports\Orders::class)->name('importorders');
    Route::get('/importorderscommission', App\Http\Livewire\Imports\OrdersCommission::class)->name('importorderscommission');
    Route::get('/erdosimport', App\Http\Livewire\Imports\ErdosImport::class)->name('erdosimport');
    Route::get('/erdosimportai', App\Http\Livewire\Imports\ErdosImportAi::class)->name('erdosimportai');


    Route::get('/importpackinglist', App\Http\Livewire\Imports\PackingList::class)->name('importpackinglist');
    Route::get('/importpackinglistupload', App\Http\Livewire\Imports\PackingListUpload::class)->name('importpackinglistupload');
    Route::get('/importpackinglistasos', App\Http\Livewire\Imports\PackingListUploadAsos::class)->name('importpackinglistasos');
    Route::get('/importasosanantapo', App\Http\Livewire\Imports\AsosAnantaInvoice::class)->name('importasosanantapo');
    Route::get('/importpackinglistasoswaltz', App\Http\Livewire\Imports\PackingListUploadAsosWaltz::class)->name('importpackinglistasoswaltz');

    Route::get('/importordersupload', App\Http\Livewire\Imports\OrdersUpload::class)->name('importordersupload');
    Route::get('/importaiordersasos', AiOrdersAsos::class)->name('importaiordersasos');
    Route::get('/importaiorderskwa', AiOrdersKwa::class)->name('importaiorderskwa');

    Route::get('/simpleorderimport', App\Http\Livewire\Imports\OrderImportSimple::class)->name('simpleorderimport');

    Route::get('/importmabliepl', PLMabliImport::class)->name('importmabliepl');
    Route::get('/importprices', App\Http\Livewire\Imports\PriceImport::class)->name('importprices');


    Route::get('/yc', YCOrdersList::class)->name('yc');
    Route::get('/ycadmin', YCAdmin::class)->name('ycadmin');


    Route::get('/viewlogs', ViewLogs::class)->name('viewlogs');
    Route::get('/viewstylelogs', StyleLog::class)->name('viewstylelogs');
    Route::get('/vieworderlogs', OrderLogs::class)->name('vieworderlogs');



    Route::post('/gemini/generate', [GeminiApiController::class, 'generate'])->name('gemini.generate');



    Route::get('/users', UsersList::class)->name('users');


    Route::post('/ssquickupdate', [SSQuickUpdate::class, 'update'])->name('ssquickupdate');


    Route::get('/z', [InvoiceController::class, 'index'])->name('invoice.index');
    Route::get('/invoice/create', [InvoiceController::class, 'create'])->name('invoice.create');
    Route::get('/auth/zoho', [ZohoAuthController::class, 'redirectToZoho'])->name('zoho.auth');
    Route::get('/auth/zoho/callback', [ZohoAuthController::class, 'handleCallback'])->name('zoho.callback');


    Route::get('/test-zoho-auth', function (ZohoService $zoho) {
        return $zoho->getAuthUrl();
    });
});
