<div>
    <style>
        .cursor-pointer {
            cursor: pointer;
        }
        .cursor-pointer:hover {
            background-color: var(--bs-gray-50);
        }
        [data-bs-theme="dark"] .cursor-pointer:hover {
            background-color: var(--bs-gray-800);
        }
    </style>
    
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">Seasons</h1>
            <p class="text-muted mb-0">Manage seasonal collections and campaigns</p>
        </div>
        <button class="btn btn-primary">
            <i class="bi bi-plus-lg me-2"></i>Add Season
        </button>
    </div>

    <!-- Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Search</label>
                    <input type="text" 
                           wire:model.live.debounce.300ms="search" 
                           class="form-control" 
                           placeholder="Search seasons...">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Status</label>
                    <select wire:model.live="statusFilter" class="form-select">
                        <option value="">All Seasons</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                        <option value="current">Current</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Per Page</label>
                    <select wire:model.live="perPage" class="form-select">
                        <option value="5">5</option>
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <div class="text-muted small">
                        Showing {{ $seasons->firstItem() ?? 0 }} to {{ $seasons->lastItem() ?? 0 }} 
                        of {{ $seasons->total() }} seasons
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Seasons List -->
    <div class="card">
        <div class="card-body p-0">
            @if($seasons->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0">Season</th>
                                <th class="border-0">Duration</th>
                                <th class="border-0">Status</th>
                                <th class="border-0">Items</th>
                                <th class="border-0">Sort Order</th>
                                <th class="border-0 text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($seasons as $season)
                                <tr class="cursor-pointer" wire:click="viewSeason({{ $season->id }})">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($season->image)
                                                <img src="{{ $season->image }}" 
                                                     alt="{{ $season->name }}" 
                                                     class="rounded me-3" 
                                                     style="width: 40px; height: 40px; object-fit: cover;">
                                            @else
                                                <div class="bg-light rounded me-3 d-flex align-items-center justify-content-center" 
                                                     style="width: 40px; height: 40px;">
                                                    <i class="bi bi-calendar3 text-muted"></i>
                                                </div>
                                            @endif
                                            <div>
                                                <div class="fw-semibold">{{ $season->name }}</div>
                                                <small class="text-muted">{{ $season->slug }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">{{ $season->duration }}</div>
                                    </td>
                                    <td>
                                        @if($season->is_current)
                                            <span class="badge bg-success">
                                                <i class="bi bi-play-circle me-1"></i>Current
                                            </span>
                                        @elseif($season->is_active)
                                            <span class="badge bg-primary">
                                                <i class="bi bi-check-circle me-1"></i>Active
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="bi bi-pause-circle me-1"></i>Inactive
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="small">{{ $season->items_count ?? 0 }} items</div>
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $season->sort_order }}</span>
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('admin.seasons.show', $season->id) }}" 
                                               class="btn btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.seasons.show', $season->id) }}" 
                                               class="btn btn-outline-secondary">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <button class="btn btn-outline-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="card-footer">
                    {{ $seasons->links() }}
                </div>
            @else
                <!-- Empty State -->
                <div class="text-center py-5">
                    <i class="bi bi-calendar3 display-1 text-muted"></i>
                    <h4 class="mt-3">No seasons found</h4>
                    <p class="text-muted">Get started by creating your first season.</p>
                    <button class="btn btn-primary">
                        <i class="bi bi-plus-lg me-2"></i>Add First Season
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>