<?php

use Illuminate\Support\Facades\Route;

Route::view('/', 'welcome');

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

require __DIR__.'/auth.php';

Route::middleware(['auth', 'role:finance'])->group(function () {
    Route::view('/finance/statements/import', 'finance.statements.import')->name('finance.statements.import');
    Route::get('/finance/statements/{statementId}/review', \App\Livewire\Finance\StatementReview::class)->name('finance.statements.review');
});
