<?php

use Illuminate\Support\Facades\Route;
use App\Livewire\Dashboard;
use App\Livewire\Manage\Index as ManageIndex;

Route::redirect('/', '/dashboard');

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

require __DIR__.'/auth.php';

Route::middleware(['auth', 'role:finance'])->group(function () {
    Route::view('/finance/statements/import', 'finance.statements.import')->name('finance.statements.import');
    Route::get('/finance/statements/{statementId}/review', \App\Livewire\Finance\StatementReview::class)->name('finance.statements.review');
    Route::get('/finance/statements', \App\Livewire\Finance\StatementsIndex::class)->name('finance.statements.index');
});

Route::middleware(['auth', 'role:user|finance'])->group(function () {
    Route::view('/receipts/upload', 'user.receipts.upload')->name('user.receipts.upload');
    Route::get('/receipts', \App\Livewire\User\ReceiptsIndex::class)->name('user.receipts.index');
});

Route::middleware(['auth', 'role:user|finance'])->group(function () {
    Route::get('/manage', ManageIndex::class)->name('manage');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/receipts/{receipt}/download', function (App\Models\Receipt $receipt) {
        if (!auth()->user()->hasRole('finance') && $receipt->user_id !== auth()->id()) {
            abort(403);
        }

        $disk = $receipt->original_disk ?? $receipt->image_disk ?? 'local';
        $path = $receipt->original_path ?? $receipt->image_path;

        if (!$path || !Storage::disk($disk)->exists($path)) {
            abort(404);
        }

        return Storage::disk($disk)->download($path);
    })->name('receipt.download');
});
