<?php
$meta = [
  'title' => 'Portfolio | Real projects and outcomes',
  'description' => 'Selected projects from my work: custom ERP, AI automation, finance and workspace migrations, and infrastructure improvements.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container">
    <h1 class="text-3xl font-bold tracking-tight">Selected Projects</h1>
    <div class="mt-8 grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
      <a class="card p-4" href="/portfolio/robert-todd-erp.php" data-portfolio-id="erp">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/erp-knitwear.jpg" width="560" height="360" alt="Knitwear factory with knitting machines and yarn spools" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Custom ERP For Manufacturing</p>
          <p class="text-sm text-gray-700">Outcome: unified processes, real‑time reporting, faster decisions.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/ai-automation-reporting.php" data-portfolio-id="ai">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/ai-streamlining.jpg" width="560" height="360" alt="Artificial intelligence concept with neon circuitry" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Streamlining Tasks With AI</p>
          <p class="text-sm text-gray-700">Outcome: hours saved weekly, fewer errors, clearer insight.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/finance-migration-zoho.php" data-portfolio-id="finance">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/finance-zoho.jpg" width="560" height="360" alt="Accounting laptop with finance charts" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Sage → Zoho Books Migration</p>
          <p class="text-sm text-gray-700">Outcome: smoother finance ops and better visibility.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/google-workspace-migration.php" data-portfolio-id="workspace">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/workspace-meeting.jpg" width="560" height="360" alt="Team collaborating in meeting room" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Google Workspace Migration & Training</p>
          <p class="text-sm text-gray-700">Outcome: simpler collaboration and less IT friction.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/it-infrastructure-modernisation.php" data-portfolio-id="itinfra">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/wifi-switch.jpg" width="560" height="360" alt="Ethernet switch with connected cables on wooden surface" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">IT Infrastructure Modernisation</p>
          <p class="text-sm text-gray-700">Outcome: reliable devices, faster Wi‑Fi, happier staff.</p>
        </div>
      </a>

    </div>

    <section class="mt-8" aria-live="polite">
      <div id="portfolio-detail" class="hidden">
        <div class="card overflow-hidden" role="region" aria-label="Project details">
          <div class="border-b border-gray-100 p-4 flex items-center justify-between">
            <h2 id="portfolio-detail-title" class="font-semibold text-gray-900"></h2>
            <button id="portfolio-detail-close" class="text-sm btn-secondary">Close</button>
          </div>
          <div id="portfolio-detail-body" class="p-4 collapse-container"></div>
        </div>
      </div>
    </section>

    <template id="tpl-erp">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900">Scope</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>End‑to‑end ERP: products, pricing, sales, manufacturing.</li>
            <li>Financial reporting with advanced SQL; automated data seeding.</li>
            <li>AI LLM tooling to assist estimation and documentation.</li>
          </ul>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900">Tech & Approach</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>Laravel 12, Livewire; JS/TS, HTML, SCSS.</li>
            <li>Microservice‑oriented PHP with CI/CD and Agile delivery.</li>
            <li>Deployed on GCP; experience transferable to AWS.</li>
          </ul>
        </div>
      </div>
      <div class="card p-4 mt-6">
        <h3 class="font-semibold text-gray-900">Outcome</h3>
        <p class="mt-2 text-sm text-gray-700">Unified workflows and real‑time reporting improved visibility and decision‑making across departments.</p>
      </div>
    </template>

    <template id="tpl-ai">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900">Problem</h3>
          <p class="mt-2 text-sm text-gray-700">Repetitive estimation/reporting tasks consumed hours and were error‑prone.</p>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900">What I built</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>AI assistants embedded in internal tools to draft estimates/docs.</li>
            <li>Automated SQL reports and lightweight dashboards.</li>
            <li>Background jobs/webhooks for hands‑off updates.</li>
          </ul>
        </div>
      </div>
      <div class="card p-4 mt-6">
        <h3 class="font-semibold text-gray-900">Outcome</h3>
        <p class="mt-2 text-sm text-gray-700">Hours saved weekly, clearer live data, fewer mistakes.</p>
      </div>
    </template>

    <template id="tpl-finance">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900">Role</h3>
          <p class="mt-2 text-sm text-gray-700">Consulted with directors/finance, mapped data, planned migration and training.</p>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900">Outcome</h3>
          <p class="mt-2 text-sm text-gray-700">Smoother operations and clearer reporting with Zoho Books.</p>
        </div>
      </div>
    </template>

    <template id="tpl-workspace">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900">What I did</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>Stakeholder management and migration planning.</li>
            <li>Provisioning, security, and data transfer.</li>
            <li>Docs and 1‑to‑1/team training.</li>
          </ul>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900">Outcome</h3>
          <p class="mt-2 text-sm text-gray-700">Simpler collaboration with shared drives, Meet, and Gmail.</p>
        </div>
      </div>
    </template>

    <template id="tpl-itinfra">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900">Responsibilities</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>Device lifecycle and procurement with vendors.</li>
            <li>Network upgrades incl. Wi‑Fi reliability improvements.</li>
            <li>Documentation, training and support for 30+ staff.</li>
          </ul>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900">Outcome</h3>
          <p class="mt-2 text-sm text-gray-700">Fewer drop‑outs, faster support, systems aligned with growth.</p>
        </div>
      </div>
    </template>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
