<?php
$meta = [
  'title' => 'Portfolio | Recent work',
  'description' => 'Simple case studies showing outcomes: clearer sites, faster pages, and more enquiries for North East businesses.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container">
    <h1 class="text-3xl font-bold tracking-tight">Recent work</h1>
    <div class="mt-8 grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
      <a class="card p-4" href="/portfolio/case-template.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-1.jpeg" width="560" height="360" alt="Plumber website case study" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Plumber — services page fix</p>
          <p class="text-sm text-gray-700">Outcome: more calls in week one.</p>
        </div>
      </a>
      <a class="card p-4" href="/portfolio/case-template.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-2.jpeg" width="560" height="360" alt="Cafe website case study" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Café — speed & menu tidy</p>
          <p class="text-sm text-gray-700">Outcome: faster page, easier updates.</p>
        </div>
      </a>
      <a class="card p-4" href="/portfolio/case-template.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-3.jpeg" width="560" height="360" alt="Office IT support case study" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Office — email & Wi‑Fi fix</p>
          <p class="text-sm text-gray-700">Outcome: fewer dropouts, happier staff.</p>
        </div>
      </a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
