<?php
$meta = [
  'title' => 'Portfolio | Real projects and outcomes',
  'description' => 'Selected projects from my work: custom ERP, AI automation, finance and workspace migrations, and infrastructure improvements.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container">
    <h1 class="text-3xl font-bold tracking-tight">Selected Projects</h1>
    <div class="mt-8 grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
      <a class="card p-4" href="/portfolio/robert-todd-erp.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/erp-knitwear.jpg" width="560" height="360" alt="Knitwear factory with knitting machines and yarn spools" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Custom ERP For Manufacturing</p>
          <p class="text-sm text-gray-700">Outcome: unified processes, real‑time reporting, faster decisions.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/ai-automation-reporting.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/ai-streamlining.jpg" width="560" height="360" alt="Artificial intelligence concept with neon circuitry" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Streamlining Tasks With AI</p>
          <p class="text-sm text-gray-700">Outcome: hours saved weekly, fewer errors, clearer insight.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/finance-migration-zoho.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/finance-zoho.jpg" width="560" height="360" alt="Accounting laptop with finance charts" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Sage → Zoho Books Migration</p>
          <p class="text-sm text-gray-700">Outcome: smoother finance ops and better visibility.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/google-workspace-migration.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/workspace-meeting.jpg" width="560" height="360" alt="Team collaborating in meeting room" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Google Workspace Migration & Training</p>
          <p class="text-sm text-gray-700">Outcome: simpler collaboration and less IT friction.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/it-infrastructure-modernisation.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/wifi-switch.jpg" width="560" height="360" alt="Ethernet switch with connected cables on wooden surface" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">IT Infrastructure Modernisation</p>
          <p class="text-sm text-gray-700">Outcome: reliable devices, faster Wi‑Fi, happier staff.</p>
        </div>
      </a>

      
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
