<?php
$meta = [
  'title' => 'Portfolio | Real projects and outcomes',
  'description' => 'Selected projects from my work: custom ERP, AI automation, finance and workspace migrations, and infrastructure improvements.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container">
    <h1 class="text-3xl font-bold tracking-tight">Selected projects</h1>
    <div class="mt-8 grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
      <a class="card p-4" href="/portfolio/robert-todd-erp.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="https://images.pexels.com/photos/3735641/pexels-photo-3735641.jpeg?auto=compress&cs=tinysrgb&w=900" width="560" height="360" alt="Knitwear factory with knitting machines and yarn spools" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Custom ERP for manufacturing</p>
          <p class="text-sm text-gray-700">Outcome: unified processes, real‑time reporting, faster decisions.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/ai-automation-reporting.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="https://images.pexels.com/photos/3861964/pexels-photo-3861964.jpeg?auto=compress&cs=tinysrgb&w=900" width="560" height="360" alt="AI data visualisation on screen" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">AI workflow automation & reporting</p>
          <p class="text-sm text-gray-700">Outcome: hours saved weekly, fewer errors, clearer insight.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/finance-migration-zoho.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="https://images.pexels.com/photos/6771607/pexels-photo-6771607.jpeg?auto=compress&cs=tinysrgb&w=900" width="560" height="360" alt="Accounting laptop with finance charts" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Sage → Zoho Books migration</p>
          <p class="text-sm text-gray-700">Outcome: smoother finance ops and better visibility.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/google-workspace-migration.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="https://images.pexels.com/photos/3183197/pexels-photo-3183197.jpeg?auto=compress&cs=tinysrgb&w=900" width="560" height="360" alt="Team collaborating in meeting room" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Google Workspace migration & training</p>
          <p class="text-sm text-gray-700">Outcome: simpler collaboration and less IT friction.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/it-infrastructure-modernisation.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="https://images.pexels.com/photos/1181354/pexels-photo-1181354.jpeg?auto=compress&cs=tinysrgb&w=900" width="560" height="360" alt="Server room and network cables" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">IT infrastructure modernisation</p>
          <p class="text-sm text-gray-700">Outcome: reliable devices, faster Wi‑Fi, happier staff.</p>
        </div>
      </a>

      
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
