<?php
$meta = [
  'title' => 'Portfolio | Real projects and outcomes',
  'description' => 'Selected projects from my work: custom ERP, AI automation, finance and workspace migrations, and infrastructure improvements.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container">
    <h1 class="text-3xl font-bold tracking-tight">Selected projects</h1>
    <div class="mt-8 grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
      <a class="card p-4" href="/portfolio/robert-todd-erp.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-1.jpeg" width="560" height="360" alt="Custom ERP for manufacturing" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Custom ERP for manufacturing</p>
          <p class="text-sm text-gray-700">Outcome: unified processes, real‑time reporting, faster decisions.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/ai-automation-reporting.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-2.jpeg" width="560" height="360" alt="AI automation and reporting" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">AI workflow automation & reporting</p>
          <p class="text-sm text-gray-700">Outcome: hours saved weekly, fewer errors, clearer insight.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/finance-migration-zoho.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-3.jpeg" width="560" height="360" alt="Sage to Zoho Books migration" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Sage → Zoho Books migration</p>
          <p class="text-sm text-gray-700">Outcome: smoother finance ops and better visibility.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/google-workspace-migration.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-1.jpeg" width="560" height="360" alt="Google Workspace migration and training" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">Google Workspace migration & training</p>
          <p class="text-sm text-gray-700">Outcome: simpler collaboration and less IT friction.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/it-infrastructure-modernisation.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-2.jpeg" width="560" height="360" alt="IT infrastructure modernisation" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">IT infrastructure modernisation</p>
          <p class="text-sm text-gray-700">Outcome: reliable devices, faster Wi‑Fi, happier staff.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/qa-dashboards-kerberos.php">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/stock/case-3.jpeg" width="560" height="360" alt="QA dashboards and Kerberos research" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900">QA dashboards & Kerberos research</p>
          <p class="text-sm text-gray-700">Outcome: live test visibility and clearer rollout decisions.</p>
        </div>
      </a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
