<?php
$meta = [
  'title' => 'Portfolio | Real projects and outcomes',
  'description' => 'Selected projects from my work: custom ERP, AI automation, finance and workspace migrations, and infrastructure improvements.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container">
    <h1 class="text-3xl font-bold tracking-tight">Selected Projects</h1>
    <div class="mt-8 grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
      <a class="card p-4" href="/portfolio/robert-todd-erp.php" data-portfolio-id="erp">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/erp-knitwear.jpg" width="560" height="360" alt="Knitwear factory with knitting machines and yarn spools" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Custom ERP For Manufacturing</p>
          <p class="text-sm text-gray-700">Outcome: unified processes, real‑time reporting, faster decisions.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/ai-automation-reporting.php" data-portfolio-id="ai">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/ai-streamlining.jpg" width="560" height="360" alt="Artificial intelligence concept with neon circuitry" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Streamlining Tasks With AI</p>
          <p class="text-sm text-gray-700">Outcome: hours saved weekly, fewer errors, clearer insight.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/finance-migration-zoho.php" data-portfolio-id="finance">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/finance-zoho.jpg" width="560" height="360" alt="Accounting laptop with finance charts" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Sage → Zoho Books Migration</p>
          <p class="text-sm text-gray-700">Outcome: smoother finance ops and better visibility.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/google-workspace-migration.php" data-portfolio-id="workspace">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/workspace-meeting.jpg" width="560" height="360" alt="Team collaborating in meeting room" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">Google Workspace Migration & Training</p>
          <p class="text-sm text-gray-700">Outcome: simpler collaboration and less IT friction.</p>
        </div>
      </a>

      <a class="card p-4" href="/portfolio/it-infrastructure-modernisation.php" data-portfolio-id="itinfra">
        <div class="rounded-xl overflow-hidden aspect-[16/10]">
          <img class="h-full w-full object-cover" src="/img/portfolio/wifi-switch.jpg" width="560" height="360" alt="Ethernet switch with connected cables on wooden surface" loading="lazy">
        </div>
        <div class="mt-3">
          <p class="font-medium text-gray-900 uppercase">IT Infrastructure Modernisation</p>
          <p class="text-sm text-gray-700">Outcome: reliable devices, faster Wi‑Fi, happier staff.</p>
        </div>
      </a>

    </div>

    <section class="mt-8" aria-live="polite">
      <div id="portfolio-detail" class="hidden">
        <div class="card overflow-hidden" role="region" aria-label="Project details">
          <div class="border-b border-gray-100 p-4 flex items-center justify-between">
            <h2 id="portfolio-detail-title" class="font-semibold text-gray-900"></h2>
            <button id="portfolio-detail-close" class="text-sm btn-secondary">Close</button>
          </div>
          <div id="portfolio-detail-body" class="p-4 collapse-container"></div>
        </div>
      </div>
    </section>

    <template id="tpl-erp">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Problem</h3>
          <p class="mt-2 text-sm text-gray-700">Disparate processes and limited real‑time visibility across product, pricing, sales and manufacturing.</p>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Solution</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>Built a Laravel 12 + Livewire ERP covering end‑to‑end workflows.</li>
            <li>Advanced SQL reporting and automated data seeding.</li>
            <li>AI LLM helpers for estimates and documentation.</li>
            <li>Microservice approach, CI/CD; deployed on GCP.</li>
          </ul>
        </div>
      </div>
    </template>

    <template id="tpl-ai">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Problem</h3>
          <p class="mt-2 text-sm text-gray-700">Repetitive estimation and reporting tasks consumed hours and introduced errors.</p>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Solution</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>Embedded AI assistants to draft estimates and documentation.</li>
            <li>Automated SQL reports with lightweight dashboards.</li>
            <li>Background jobs and webhooks for hands‑off updates.</li>
          </ul>
        </div>
      </div>
    </template>

    <template id="tpl-finance">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Problem</h3>
          <p class="mt-2 text-sm text-gray-700">Legacy Sage setup limited adaptability and visibility as the business evolved.</p>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Solution</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>Planned and managed migration to Zoho Books with stakeholders.</li>
            <li>Data mapping, training and rollout with minimal disruption.</li>
            <li>Improved reporting to support day‑to‑day finance ops.</li>
          </ul>
        </div>
      </div>
    </template>

    <template id="tpl-workspace">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Problem</h3>
          <p class="mt-2 text-sm text-gray-700">Growing team needed reliable collaboration and communication tools.</p>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Solution</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>Stakeholder planning; provisioning and security setup.</li>
            <li>Data migration to Google Workspace; shared drives.</li>
            <li>Documentation plus 1‑to‑1 and team training.</li>
          </ul>
        </div>
      </div>
    </template>

    <template id="tpl-itinfra">
      <div class="grid gap-6 md:grid-cols-2">
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Problem</h3>
          <p class="mt-2 text-sm text-gray-700">Mixed device fleet and unreliable Wi‑Fi caused drop‑outs and support overhead.</p>
        </div>
        <div>
          <h3 class="font-semibold text-gray-900 uppercase">Solution</h3>
          <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
            <li>Procurement and lifecycle management across Windows/macOS/Linux/ChromeOS.</li>
            <li>Network upgrades, improved Wi‑Fi coverage and reliability.</li>
            <li>Documentation, training and responsive support for 30+ staff.</li>
          </ul>
        </div>
      </div>
    </template>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
