@extends('layouts.shop')

@section('title', 'Register - Yarn Store')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item active">Register</li>
            </ol>
        </nav>
        
        <h1 class="fw-bold mb-0">Create Your Account</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-5 col-md-7">
            <div class="ys-card p-4 p-md-5">
                <div class="text-center mb-4">
                    <h2 class="fw-bold mb-2">Join Yarn Store</h2>
                    <p class="text-muted">Create an account to start shopping and track your orders</p>
                </div>

                <form method="POST" action="{{ route('register') }}">
                    @csrf

                    <div class="mb-4">
                        <label for="name" class="form-label fw-semibold">{{ __('Name') }}</label>
                        <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus placeholder="Enter your full name">

                        @error('name')
                            <div class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </div>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label for="email" class="form-label fw-semibold">{{ __('Email Address') }}</label>
                        <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="Enter your email">

                        @error('email')
                            <div class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </div>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label for="password" class="form-label fw-semibold">{{ __('Password') }}</label>
                        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" placeholder="Create a password">

                        @error('password')
                            <div class="invalid-feedback d-block" role="alert">
                                <strong>{{ $message }}</strong>
                            </div>
                        @enderror
                    </div>

                    <div class="mb-4">
                        <label for="password-confirm" class="form-label fw-semibold">{{ __('Confirm Password') }}</label>
                        <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password" placeholder="Confirm your password">
                    </div>

                    <div class="d-grid mb-3">
                        <button type="submit" class="btn btn-ys-primary btn-lg">
                            {{ __('Register') }}
                        </button>
                    </div>

                    <div class="border-top pt-4 text-center">
                        <p class="text-muted mb-0">Already have an account? 
                            <a href="{{ route('login') }}" class="text-decoration-none fw-semibold" style="color: var(--ys-moss-green-dark);">
                                Login here
                            </a>
                        </p>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
