<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Account;

class AccountSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $accounts = [
            ['name' => 'Subsistence', 'code' => 'SUBS'],
            ['name' => 'Travel', 'code' => 'TRAV'],
            ['name' => 'Entertainment', 'code' => 'ENT'],
            ['name' => 'Stationery', 'code' => 'STAT'],
            ['name' => 'Computing', 'code' => 'COMP'],
            ['name' => 'Other', 'code' => 'OTHER'],
        ];

        foreach ($accounts as $acc) {
            Account::firstOrCreate(['name' => $acc['name']], $acc);
        }
    }
}
