const db = require('./src/db-multi-tenant');
const stripeService = require('./src/stripe-service');

async function testUpgrade() {
  try {
    console.log('Testing upgrade flow...\n');
    
    // Get user 8
    const user = await db.getUserById(8);
    console.log('User:', {
      id: user.id,
      username: user.username,
      subscriptionTier: user.subscriptionTier,
      stripeCustomerId: user.stripeCustomerId,
      stripeSubscriptionId: user.stripeSubscriptionId
    });
    
    // Check if Stripe is configured
    const isConfigured = await stripeService.isConfigured();
    console.log('\nStripe configured:', isConfigured);
    
    // Try to create checkout session
    if (user.stripeCustomerId) {
      console.log('\nAttempting to create checkout session...');
      const checkoutUrl = await stripeService.createCheckoutSession(
        user.stripeCustomerId,
        'business',
        'http://localhost:3000/admin/subscription/upgrade-complete?session_id={CHECKOUT_SESSION_ID}',
        'http://localhost:3000/admin/subscription?canceled=true',
        false,
        user.stripeSubscriptionId
      );
      console.log('Checkout URL:', checkoutUrl);
    }
    
  } catch (error) {
    console.error('Error:', error);
  } finally {
    process.exit(0);
  }
}

testUpgrade();

