<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LibraryTrack;
use Illuminate\Http\Request;

class LibraryAdminController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'category_id' => ['required', 'integer', 'exists:library_categories,id'],
            'title' => ['required', 'string'],
            'slug' => ['required', 'string', 'unique:library_tracks,slug'],
            'duration_sec' => ['required', 'integer', 'min:1'],
            'audio_path' => ['required', 'string'],
            'transcript_path' => ['nullable', 'string'],
            'tags' => ['nullable', 'array'],
            'published_at' => ['nullable', 'date'],
        ]);
        $track = LibraryTrack::create($data);
        return response()->json($track, 201);
    }

    public function update(Request $request, int $id)
    {
        $track = LibraryTrack::findOrFail($id);
        $data = $request->validate([
            'title' => ['sometimes', 'string'],
            'duration_sec' => ['sometimes', 'integer', 'min:1'],
            'audio_path' => ['sometimes', 'string'],
            'transcript_path' => ['nullable', 'string'],
            'tags' => ['nullable', 'array'],
            'published_at' => ['nullable', 'date'],
        ]);
        $track->update($data);
        return response()->json($track);
    }

    public function destroy(int $id)
    {
        $track = LibraryTrack::findOrFail($id);
        $track->delete();
        return response()->noContent();
    }
}


