<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_lines', function (Blueprint $table) {
            $table->id();
            $table->foreignId('orders_id')->constrained('orders')->onDelete('cascade');
            $table->foreignId('colourways_id')->nullable()->constrained('colourways')->onDelete('set null');
            
            // Denormalized data - store item info at time of order
            $table->string('item_name'); // Snapshot of item name
            $table->text('item_description')->nullable(); // Snapshot of item description
            $table->string('colourway_name')->nullable(); // Snapshot of colourway name
            $table->string('item_sku')->nullable(); // Snapshot of item SKU
            $table->decimal('unit_price', 10, 2); // Price at time of order
            $table->integer('quantity');
            $table->decimal('line_total', 10, 2); // unit_price * quantity
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_lines');
    }
};
