@extends('layouts.frontend')

@section('meta_title', ($season->meta_title ?? $season->name) . ' - Yarn Store')
@section('meta_description', $season->meta_description ?? $season->description)

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <a href="{{ route('collections') }}">Collections</a>
                <span>/</span>
                <span>{{ $season->name }}</span>
            </nav>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-lg-8 mx-auto text-center">
            <h1 class="display-4 fw-bold mb-3">{{ $season->name }}</h1>
            @if($season->description)
                <p class="lead text-muted">{{ $season->description }}</p>
            @endif
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-12">
            <h2 class="h4 fw-bold mb-4">Browse by Category</h2>
        </div>
    </div>

    <div class="row g-4">
        @forelse($categories as $category)
            <div class="col-lg-3 col-md-4 col-sm-6">
                <a href="{{ route('category', $category->slug) }}?season={{ $season->slug }}" class="text-decoration-none">
                    <div class="ys-card text-center p-4 h-100">
                        <div class="mb-3">
                            <div class="rounded-circle d-inline-flex align-items-center justify-content-center" 
                                 style="width: 80px; height: 80px; background-color: var(--ys-primary); opacity: 0.1;">
                            </div>
                        </div>
                        <h3 class="h5 fw-bold mb-2" style="color: var(--ys-text-primary);">
                            {{ $category->name }}
                        </h3>
                        <p class="text-muted small mb-0">
                            {{ $category->items_count }} {{ Str::plural('item', $category->items_count) }}
                        </p>
                    </div>
                </a>
            </div>
        @empty
            <div class="col-12">
                <div class="ys-card p-5 text-center">
                    <p class="text-muted mb-0">No categories available for this season yet.</p>
                </div>
            </div>
        @endforelse
    </div>
</div>
@endsection

