<?php

namespace App\Http\Controllers;

use App\Models\Subscription;
use App\Models\Webhook;
use Illuminate\Http\Request;

class IAPController extends Controller
{
    public function verify(Request $request)
    {
        $data = $request->validate([
            'receipt' => ['required', 'string'],
        ]);

        // TODO: Implement App Store Server API verification
        // Placeholder structure for future logic:
        // - call Apple API with shared secret / JWT
        // - verify bundle_id, product_id, transaction state
        // - update subscription rows and entitlements
        $sub = Subscription::updateOrCreate([
            'user_id' => $request->user()->id,
        ], [
            'store' => 'apple',
            'product_id' => 'premium_monthly',
            'status' => 'active',
            'period_end_at' => now()->addMonth(),
            'latest_receipt' => ['token' => 'mock'],
        ]);

        return response()->json(['status' => 'ok', 'subscription' => $sub]);
    }

    public function entitlements(Request $request)
    {
        $sub = Subscription::where('user_id', $request->user()->id)->whereIn('status', ['active', 'in_grace'])->first();

        return response()->json([
            'active' => (bool) $sub,
            'product_id' => $sub?->product_id,
            'period_end_at' => optional($sub?->period_end_at)->toISOString(),
        ]);
    }

    public function webhook(Request $request)
    {
        // TODO: Verify signature, prevent replay, enqueue processing
        $webhook = Webhook::create([
            'provider' => 'apple',
            'event' => $request->header('X-Event', 'unknown'),
            'payload' => $request->all(),
        ]);

        return response()->json(['id' => $webhook->id], 202);
    }
}
