const bcrypt = require('bcrypt');
const db = require('./src/db-multi-tenant');

async function resetPassword() {
  try {
    const email = 'admin@vybephoto.com';
    const newPassword = 'Superuser123!'; // Strong password
    
    // Hash the password
    const hashedPassword = await bcrypt.hash(newPassword, 10);
    
    // Update the password
    await db.pool.query(
      'UPDATE users SET password_hash = $1 WHERE email = $2',
      [hashedPassword, email]
    );
    
    console.log('✅ Superuser password reset successfully!\n');
    console.log('Login credentials:');
    console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
    console.log(`Email:    ${email}`);
    console.log(`Password: ${newPassword}`);
    console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n');
    console.log('Go to: http://app.localhost:3000/login');
    
  } catch (error) {
    console.error('Error:', error.message);
  } finally {
    process.exit(0);
  }
}

resetPassword();

