<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Profile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'wellness_goals',
        'voice_preference',
        'sensitivity_level',
        'medical_notes',
        'preferences',
    ];

    protected $casts = [
        'wellness_goals' => 'array',
        'preferences' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scopeByVoicePreference($query, $preference)
    {
        return $query->where('voice_preference', $preference);
    }

    public function scopeBySensitivityLevel($query, $level)
    {
        return $query->where('sensitivity_level', $level);
    }

    public function hasWellnessGoal(string $goal): bool
    {
        return in_array($goal, $this->wellness_goals ?? []);
    }

    public function addWellnessGoal(string $goal): void
    {
        $goals = $this->wellness_goals ?? [];
        if (!in_array($goal, $goals)) {
            $goals[] = $goal;
            $this->update(['wellness_goals' => $goals]);
        }
    }

    public function removeWellnessGoal(string $goal): void
    {
        $goals = $this->wellness_goals ?? [];
        $goals = array_filter($goals, fn($g) => $g !== $goal);
        $this->update(['wellness_goals' => array_values($goals)]);
    }
}
