<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Profile extends Model
{
    protected $fillable = [
        'user_id',
        'goals',
        'voice_preference',
        'sensitivity_level',
        'wellness_interests',
        'timezone',
        'notifications_enabled',
    ];

    protected $casts = [
        'wellness_interests' => 'array',
        'notifications_enabled' => 'boolean',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
