<?php

namespace App\Services\Finance;

use App\Models\Receipt;
use App\Jobs\ProcessVatAnalysis;
use Illuminate\Support\Facades\Log;

class FinanceSubmissionService
{
    /**
     * Submit receipts to finance and trigger VAT processing
     */
    public function submitReceiptsToFinance(array $receiptIds): void
    {
        $receipts = Receipt::whereIn('id', $receiptIds)->get();
        
        Log::info("Submitting receipts to finance", [
            'receipt_count' => count($receiptIds),
            'receipt_ids' => $receiptIds
        ]);
        
        // Trigger VAT processing for each receipt
        foreach ($receipts as $receipt) {
            ProcessVatAnalysis::dispatch($receipt->id, 'finance_submission')
                ->delay(now()->addSeconds(5)); // Small delay to avoid overwhelming the system
        }
        
        Log::info("VAT processing jobs dispatched for finance submission", [
            'receipt_count' => count($receiptIds)
        ]);
    }
}
