<div class="min-h-screen bg-gradient-to-br from-primary-50 via-accent-50 to-primary-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Header -->
        <div class="text-center mb-12">
            <h1 class="text-4xl font-bold font-heading text-neutral-900 mb-4 tracking-heading">
                My Custom Sessions
            </h1>
            <p class="text-xl text-neutral-600 max-w-2xl mx-auto leading-relaxed">
                Track the progress of your personalized wellness sessions and access them when ready.
            </p>
        </div>

        <!-- Search and Filters -->
        <div class="bg-white rounded-2xl shadow-md p-6 mb-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <!-- Search -->
                <div>
                    <label for="search" class="block text-sm font-medium text-neutral-700 mb-2">Search</label>
                    <div class="relative">
                        <input 
                            wire:model.live.debounce.300ms="search"
                            type="text" 
                            id="search"
                            placeholder="Search sessions..."
                            class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-2 transition-colors"
                        >
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <svg class="h-5 w-5 text-neutral-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                            </svg>
                        </div>
                    </div>
                </div>

                <!-- Status Filter -->
                <div>
                    <label for="status" class="block text-sm font-medium text-neutral-700 mb-2">Status</label>
                    <select 
                        wire:model.live="statusFilter"
                        id="status"
                        class="w-full rounded-full border-neutral-200 focus:border-primary-400 focus:ring-primary-200 px-4 py-2 transition-colors"
                    >
                        <option value="">All Statuses</option>
                        <option value="queued">Queued</option>
                        <option value="generating">Generating</option>
                        <option value="ready">Ready</option>
                        <option value="failed">Failed</option>
                    </select>
                </div>

                <!-- Clear Filters -->
                <div class="flex items-end">
                    @if($search || $statusFilter)
                        <button 
                            wire:click="clearFilters"
                            class="w-full inline-flex items-center justify-center px-4 py-2 text-sm font-medium text-neutral-600 bg-neutral-100 hover:bg-neutral-200 rounded-full transition-colors"
                        >
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                            Clear Filters
                        </button>
                    @endif
                </div>
            </div>
        </div>

        <!-- Sessions List -->
        @if($sessions->count() > 0)
            <div class="space-y-6">
                @foreach($sessions as $session)
                    <div class="bg-white rounded-2xl shadow-md hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] overflow-hidden">
                        <div class="p-6">
                            <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                                <!-- Session Info -->
                                <div class="flex-1 mb-4 lg:mb-0">
                                    <div class="flex items-start justify-between mb-3">
                                        <h3 class="text-xl font-semibold font-heading text-neutral-900">
                                            {{ $session->title }}
                                        </h3>
                                        <!-- Status Badge -->
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium 
                                            @if($session->status === 'ready') bg-green-100 text-green-800
                                            @elseif($session->status === 'generating') bg-blue-100 text-blue-800
                                            @elseif($session->status === 'queued') bg-yellow-100 text-yellow-800
                                            @else bg-red-100 text-red-800
                                            @endif">
                                            @if($session->status === 'ready')
                                                <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                                </svg>
                                            @elseif($session->status === 'generating')
                                                <svg class="w-3 h-3 mr-1 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                                </svg>
                                            @elseif($session->status === 'queued')
                                                <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                            @else
                                                <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                            @endif
                                            {{ ucfirst($session->status) }}
                                        </span>
                                    </div>

                                    @if($session->description)
                                        <p class="text-neutral-600 mb-3 leading-relaxed">
                                            {{ $session->description }}
                                        </p>
                                    @endif

                                    <!-- Meta Info -->
                                    <div class="flex flex-wrap items-center gap-4 text-sm text-neutral-500">
                                        @if($session->duration)
                                            <span class="flex items-center">
                                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                                {{ gmdate('i:s', $session->duration) }}
                                            </span>
                                        @endif
                                        
                                        <span class="flex items-center">
                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                            </svg>
                                            {{ ucfirst($session->voice_type) }} voice
                                        </span>

                                        <span class="flex items-center">
                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                            </svg>
                                            {{ $session->created_at->format('M j, Y') }}
                                        </span>

                                        @if($session->play_count > 0)
                                            <span class="flex items-center">
                                                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h1m4 0h1m-6 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                                {{ $session->play_count }} {{ Str::plural('play', $session->play_count) }}
                                            </span>
                                        @endif
                                    </div>

                                    <!-- Audio Player for Ready Sessions -->
                                    @if($session->status === 'ready' && $session->file_path && $session->audio_url)
                                        <div class="mt-4 p-4 bg-gradient-to-r from-primary-50 to-accent-50 rounded-xl border border-primary-100">
                                            <h4 class="text-sm font-medium text-primary-800 mb-3">Listen to Your Session</h4>
                                            <audio 
                                                class="w-full"
                                                controls
                                                preload="metadata"
                                                wire:ignore
                                            >
                                                <source src="{{ $session->audio_url }}" type="audio/mpeg">
                                                Your browser does not support the audio element.
                                            </audio>
                                            <div class="mt-2 text-xs text-primary-600">
                                                <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                                    </svg>
                                                    Ready to Play
                                                </span>
                                            </div>
                                        </div>
                                    @endif

                                    <!-- Progress Bar for Generating Status -->
                                    @if($session->status === 'generating')
                                        <div class="mt-4">
                                            <div class="w-full bg-neutral-200 rounded-full h-2">
                                                <div class="bg-gradient-to-r from-primary-400 to-accent-500 h-2 rounded-full animate-pulse" style="width: 60%"></div>
                                            </div>
                                            <p class="text-xs text-neutral-500 mt-2">AI is generating your personalized session...</p>
                                        </div>
                                    @endif

                                    <!-- Failure Reason -->
                                    @if($session->status === 'failed' && $session->failure_reason)
                                        <div class="mt-4 p-3 bg-red-50 border border-red-200 rounded-xl">
                                            <p class="text-sm text-red-800">
                                                <strong>Error:</strong> {{ $session->failure_reason }}
                                            </p>
                                        </div>
                                    @endif
                                </div>

                                <!-- Action Buttons -->
                                <div class="flex flex-col sm:flex-row gap-3 lg:ml-6">
                                    @if($session->status === 'ready')
                                        <a 
                                            href="{{ route('custom.sessions.show', $session) }}"
                                            class="inline-flex items-center justify-center px-6 py-3 border border-transparent text-sm font-medium rounded-full text-white bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg"
                                        >
                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h1m4 0h1m-6 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            </svg>
                                            Listen Now
                                        </a>
                                    @elseif($session->status === 'failed')
                                        <button 
                                            class="inline-flex items-center justify-center px-6 py-3 border border-transparent text-sm font-medium rounded-full text-white bg-gradient-to-r from-accent-400 to-accent-500 hover:from-accent-500 hover:to-accent-600 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg"
                                        >
                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                            </svg>
                                            Retry
                                        </button>
                                    @else
                                        <div class="inline-flex items-center justify-center px-6 py-3 border border-transparent text-sm font-medium rounded-full text-neutral-500 bg-neutral-100 cursor-not-allowed">
                                            @if($session->status === 'queued')
                                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                                In Queue
                                            @else
                                                <svg class="w-4 h-4 mr-2 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                                </svg>
                                                Generating...
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- Pagination -->
            <div class="mt-12">
                {{ $sessions->links() }}
            </div>
        @else
            <!-- No Sessions -->
            <div class="text-center py-16">
                <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-neutral-100 mb-4">
                    <svg class="h-8 w-8 text-neutral-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-medium text-neutral-900 mb-2">No custom sessions yet</h3>
                <p class="text-neutral-600 mb-6">Start by requesting a personalized wellness session tailored to your needs.</p>
                <a 
                    href="{{ route('custom.create') }}"
                    class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-full text-white bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 transition-all duration-300 transform hover:scale-105 shadow-md hover:shadow-lg"
                >
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    Request Custom Session
                </a>
            </div>
        @endif
    </div>
</div>
