<div class="space-y-4">
    <div class="flex justify-between items-center">
        <h3 class="text-lg font-semibold">Statements</h3>
        <a class="text-blue-600 underline" href="{{ route('finance.statements.import') }}">Import</a>
    </div>
    <div class="overflow-x-auto bg-white dark:bg-gray-800 rounded shadow">
        <table class="min-w-full text-sm">
            <thead>
                <tr class="text-left">
                    <th class="px-3 py-2">Cardholder</th>
                    <th class="px-3 py-2">Account</th>
                    <th class="px-3 py-2">Period</th>
                    <th class="px-3 py-2">Status</th>
                    <th class="px-3 py-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($statements as $s)
                    <tr class="border-t">
                        <td class="px-3 py-2">{{ $s->cardholder_name }}</td>
                        <td class="px-3 py-2">{{ $s->account_number_masked }}</td>
                        <td class="px-3 py-2">{{ $s->period_start }} → {{ $s->period_end }}</td>
                        <td class="px-3 py-2">{{ ucfirst($s->status) }}</td>
                        <td class="px-3 py-2">
                            <a class="text-blue-600 underline" href="{{ route('finance.statements.review', ['statementId' => $s->id]) }}">Review</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
