@extends('layouts.shop')

@section('title', 'Free Patterns - Yarn Store')
@section('meta_description', 'Browse our collection of free knitting and crochet patterns. From beginner to advanced projects.')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">Free Patterns</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-12 text-center py-5">
            <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mb-3" style="color: var(--ys-primary);">
                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                <polyline points="14 2 14 8 20 8"></polyline>
                <line x1="16" y1="13" x2="8" y2="13"></line>
                <line x1="16" y1="17" x2="8" y2="17"></line>
                <polyline points="10 9 9 9 8 9"></polyline>
            </svg>
            <h2 class="fw-bold mb-3">Free Patterns Coming Soon!</h2>
            <p class="text-muted mb-4">We're currently curating a collection of beautiful free patterns for you. Check back soon!</p>
            <p class="mb-4">In the meantime, explore our yarn collection to find inspiration for your next project.</p>
            <a href="{{ route('shop.all') }}" class="btn btn-ys-primary btn-lg">
                Browse Yarns
            </a>
        </div>
    </div>
</div>
@endsection

