@section('title', 'My Account - Yarn Store')

<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">My Account</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4 mb-lg-0">
            @include('partials.account-sidebar')
        </div>

        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="mb-4">
                <h2 class="fw-bold mb-3">Welcome back, {{ Auth::user()->name }}!</h2>
                <p class="text-muted">Manage your orders, profile, and preferences from your account dashboard.</p>
            </div>

            <!-- Quick Stats -->
            <div class="row g-4 mb-4">
                <div class="col-md-4">
                    <div class="ys-card p-4 text-center">
                        <div class="mb-2" style="color: var(--ys-primary);">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                                <circle cx="9" cy="7" r="4"></circle>
                                <path d="M22 21v-2a4 4 0 0 0-3-3.87"></path>
                                <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                            </svg>
                        </div>
                        <h4 class="fw-bold mb-1">{{ $orderCount }}</h4>
                        <p class="text-muted small mb-0">Total Orders</p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="ys-card p-4 text-center">
                        <div class="mb-2" style="color: var(--ys-primary);">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                                <circle cx="12" cy="10" r="3"></circle>
                            </svg>
                        </div>
                        <h4 class="fw-bold mb-1">{{ Auth::user()->addresses->count() }}</h4>
                        <p class="text-muted small mb-0">Saved Addresses</p>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="ys-card p-4 text-center">
                        <div class="mb-2" style="color: var(--ys-primary);">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"></circle>
                                <polyline points="12 6 12 12 16 14"></polyline>
                            </svg>
                        </div>
                        <h4 class="fw-bold mb-1">{{ Auth::user()->created_at->diffForHumans(null, true) }}</h4>
                        <p class="text-muted small mb-0">Member Since</p>
                    </div>
                </div>
            </div>

            <!-- Recent Orders -->
            <div class="ys-card p-4">
                <h4 class="fw-bold mb-4">Recent Orders</h4>
                
                @if($recentOrders->count() > 0)
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Order Number</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Total</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recentOrders as $order)
                                    <tr>
                                        <td class="fw-semibold">{{ $order->order_number }}</td>
                                        <td>{{ $order->created_at->format('d M Y') }}</td>
                                        <td>
                                            <span class="badge bg-primary">{{ ucfirst($order->status) }}</span>
                                        </td>
                                        <td class="fw-bold" style="color: var(--ys-primary);">
                                            £{{ number_format($order->initial_total_amount, 2) }}
                                        </td>
                                        <td>
                                            <a href="{{ route('account.order', $order->id) }}" class="btn btn-sm btn-outline-primary">
                                                View
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="text-center mt-3">
                        <a href="{{ route('account.orders') }}" class="btn btn-ys-primary">
                            View All Orders
                        </a>
                    </div>
                @else
                    <div class="text-center py-4">
                        <p class="text-muted mb-3">You haven't placed any orders yet.</p>
                        <a href="{{ route('shop.all') }}" class="btn btn-ys-primary">
                            Start Shopping
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

