const db = require('./src/db-multi-tenant');

async function testTierSave() {
  try {
    // Check current database schema
    console.log('Checking subscription_tiers table schema...');
    const schemaResult = await db.pool.query(`
      SELECT column_name, data_type, is_nullable
      FROM information_schema.columns
      WHERE table_name = 'subscription_tiers'
      ORDER BY ordinal_position;
    `);
    
    console.log('\nTable columns:');
    schemaResult.rows.forEach(col => {
      console.log(`  - ${col.column_name}: ${col.data_type} (nullable: ${col.is_nullable})`);
    });
    
    // Check current tier data
    console.log('\n\nCurrent tier data:');
    const tiersResult = await db.pool.query(`
      SELECT id, tier_key, tier_name, stripe_price_id, stripe_product_id 
      FROM subscription_tiers 
      ORDER BY display_order;
    `);
    
    tiersResult.rows.forEach(tier => {
      console.log(`\n  Tier: ${tier.tier_name} (${tier.tier_key})`);
      console.log(`    ID: ${tier.id}`);
      console.log(`    Stripe Price ID: ${tier.stripe_price_id || '(not set)'}`);
      console.log(`    Stripe Product ID: ${tier.stripe_product_id || '(not set)'}`);
    });
    
    await db.pool.end();
    process.exit(0);
  } catch (error) {
    console.error('Error:', error);
    process.exit(1);
  }
}

testTierSave();

