<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LibraryController;
use App\Http\Controllers\CustomSessionController;
use App\Http\Controllers\AdminController;

// Public routes
Route::view('/', 'welcome')->name('welcome');

// Library routes (public)
Route::get('/library', [LibraryController::class, 'index'])->name('library.index');
Route::get('/library/category/{slug}', [LibraryController::class, 'category'])->name('library.category');
Route::get('/library/track/{slug}', [LibraryController::class, 'track'])->name('library.track');
Route::get('/library/search', [LibraryController::class, 'search'])->name('library.search');

// Custom session routes (public form, protected sessions)
Route::get('/custom', [CustomSessionController::class, 'create'])->name('custom.create');
Route::get('/custom/sessions', [CustomSessionController::class, 'index'])
    ->middleware(['auth'])
    ->name('custom.sessions.index');
Route::get('/custom/sessions/{session}', [CustomSessionController::class, 'show'])
    ->middleware(['auth'])
    ->name('custom.sessions.show');

// Protected routes
Route::middleware(['auth'])->group(function () {
    Route::view('dashboard', 'dashboard')->name('dashboard');
    Route::view('profile', 'profile')->name('profile');
    
    // Admin routes
    Route::middleware('admin')->group(function () {
        Route::get('/admin', [AdminController::class, 'index'])->name('admin.index');
        Route::get('/admin/categories', [AdminController::class, 'categories'])->name('admin.categories');
        Route::get('/admin/tracks', [AdminController::class, 'tracks'])->name('admin.tracks');
        Route::get('/admin/safety-events', [AdminController::class, 'safetyEvents'])->name('admin.safety-events');
    });
});

require __DIR__.'/auth.php';
