<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;

// Public routes
Route::view('/', 'welcome')->name('welcome');

// Library routes (public) - using Livewire components
Route::get('/library', \App\Livewire\LibraryPage::class)->name('library.index');
Route::get('/library/category/{slug}', \App\Livewire\LibraryPage::class)->name('library.category');
Route::get('/library/track/{slug}', \App\Livewire\TrackDetail::class)->name('library.track');
Route::get('/library/search', \App\Livewire\LibraryPage::class)->name('library.search');

// Custom session routes (public form, protected sessions) - using Livewire components
Route::get('/custom', \App\Livewire\CustomSessionForm::class)->name('custom.create');
Route::get('/custom/sessions', \App\Livewire\CustomSessionsList::class)
    ->middleware(['auth'])
    ->name('custom.sessions.index');
Route::get('/custom/sessions/{session}', \App\Livewire\CustomSessionsList::class)
    ->middleware(['auth'])
    ->name('custom.sessions.show');

// Protected routes
Route::middleware(['auth'])->group(function () {
    Route::view('dashboard', 'dashboard')->name('dashboard');
    Route::view('profile', 'profile')->name('profile');
    
    // Admin routes
    Route::middleware('admin')->group(function () {
        Route::get('/admin', [AdminController::class, 'index'])->name('admin.index');
        Route::get('/admin/categories', [AdminController::class, 'categories'])->name('admin.categories');
        Route::get('/admin/tracks', [AdminController::class, 'tracks'])->name('admin.tracks');
        Route::get('/admin/safety-events', [AdminController::class, 'safetyEvents'])->name('admin.safety-events');
        Route::get('/admin/custom-requests', [AdminController::class, 'customRequests'])->name('admin.custom-requests');
        Route::post('/admin/custom-requests/{id}/approve', [AdminController::class, 'approveRequest'])->name('admin.approve-request');
        Route::post('/admin/custom-requests/{id}/reject', [AdminController::class, 'rejectRequest'])->name('admin.reject-request');
        Route::post('/admin/safety-events/{id}/resolve', [AdminController::class, 'resolveSafetyEvent'])->name('admin.resolve-safety-event');
    });
});

require __DIR__.'/auth.php';
