<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LibraryController;

Route::view('/', 'welcome');

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

// Library routes
Route::get('/library', [LibraryController::class, 'index'])->name('library.index');
Route::get('/library/category/{slug}', [LibraryController::class, 'category'])->name('library.category');
Route::get('/library/track/{slug}', [LibraryController::class, 'track'])->name('library.track');
Route::get('/library/search', [LibraryController::class, 'search'])->name('library.search');

require __DIR__.'/auth.php';
