<div>
    <!-- Welcome Section -->
    <div class="mb-4">
        <h1 class="h2 mb-2">Welcome back, {{ Auth::user()->name }}!</h1>
        <p class="text-muted">Here's what's happening with your store today.</p>
    </div>

    <!-- Stats Grid -->
    <div class="row g-4 mb-4">
        <!-- Total Orders -->
        <div class="col-md-6 col-lg-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="p-3 rounded-circle bg-primary text-white me-3">
                            <i class="bi bi-cart-check fs-4"></i>
                        </div>
                        <div>
                            <p class="text-muted small mb-1">Total Orders</p>
                            <p class="h4 mb-0">0</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Customers -->
        <div class="col-md-6 col-lg-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="p-3 rounded-circle bg-success text-white me-3">
                            <i class="bi bi-people fs-4"></i>
                        </div>
                        <div>
                            <p class="text-muted small mb-1">Total Customers</p>
                            <p class="h4 mb-0">{{ \App\Models\User::where('role', 'user')->count() }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Total Items -->
        <div class="col-md-6 col-lg-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="p-3 rounded-circle bg-info text-white me-3">
                            <i class="bi bi-box fs-4"></i>
                        </div>
                        <div>
                            <p class="text-muted small mb-1">Total Items</p>
                            <p class="h4 mb-0">0</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Revenue -->
        <div class="col-md-6 col-lg-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="p-3 rounded-circle bg-warning text-white me-3">
                            <i class="bi bi-currency-dollar fs-4"></i>
                        </div>
                        <div>
                            <p class="text-muted small mb-1">Total Revenue</p>
                            <p class="h4 mb-0">£0.00</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="row g-4">
        <!-- Recent Orders -->
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Recent Orders</h5>
                </div>
                <div class="card-body">
                    <div class="text-center py-4">
                        <i class="bi bi-cart-x display-1 text-muted"></i>
                        <h4 class="mt-3">No orders yet</h4>
                        <p class="text-muted">Get started by creating your first order.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-3">
                        <a href="{{ route('admin.items') }}" 
                           class="btn btn-outline-primary d-flex align-items-center">
                            <i class="bi bi-plus-circle me-2"></i>
                            Add New Item
                        </a>
                        
                        <a href="{{ route('admin.categories') }}" 
                           class="btn btn-outline-secondary d-flex align-items-center">
                            <i class="bi bi-tags me-2"></i>
                            Manage Categories
                        </a>
                        
                        <a href="{{ route('admin.seasons') }}" 
                           class="btn btn-outline-info d-flex align-items-center">
                            <i class="bi bi-calendar3 me-2"></i>
                            Manage Seasons
                        </a>
                        
                        <a href="{{ route('admin.customers') }}" 
                           class="btn btn-outline-success d-flex align-items-center">
                            <i class="bi bi-people me-2"></i>
                            View Customers
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>