<x-app-layout>
    <div id="page-content">
        <x-title-bar>
            <x-slot:title>
                <div class="d-flex align-items-center">
                    <i class="fas fa-tachometer-alt text-primary me-3 fs-2"></i>
                    <span class="fs-3 fw-bold text-gradient">Dashboard</span>
                </div>
            </x-slot:title>
            <x-slot:end>
                <div class="d-flex gap-2">
                    <button class="btn btn-outline-primary btn-sm" onclick="refreshDashboard()">
                        <i class="fas fa-sync-alt me-1"></i>Refresh All
                    </button>
                    <button class="btn btn-primary btn-sm" onclick="exportDashboard()">
                        <i class="fas fa-download me-1"></i>Export
                    </button>
                </div>
            </x-slot:end>
        </x-title-bar>

        <!-- Modern Dashboard Grid -->
        <div class="container-fluid px-4 py-3">
            <!-- Key Metrics Row -->
            <div class="row g-4 mb-4">
                <div class="col-12">
                    <div class="row g-3">
                        <!-- Quick Stats Cards -->
                        <div class="col-sm-6 col-lg-3">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="text-primary mb-2">
                                        <i class="fas fa-chart-line fs-1"></i>
                                    </div>
                                    <h5 class="card-title text-muted mb-1">Total Sales</h5>
                                    <h3 class="text-success mb-0" id="total-sales">-</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="text-warning mb-2">
                                        <i class="fas fa-clock fs-1"></i>
                                    </div>
                                    <h5 class="card-title text-muted mb-1">Pending</h5>
                                    <h3 class="text-warning mb-0" id="pending-sales">-</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="text-info mb-2">
                                        <i class="fas fa-users fs-1"></i>
                                    </div>
                                    <h5 class="card-title text-muted mb-1">Customers</h5>
                                    <h3 class="text-info mb-0" id="total-customers">-</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-3">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-body text-center">
                                    <div class="text-success mb-2">
                                        <i class="fas fa-percentage fs-1"></i>
                                    </div>
                                    <h5 class="card-title text-muted mb-1">Progress</h5>
                                    <h3 class="text-success mb-0" id="avg-progress">-</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dashboard Sections -->
            <div class="row g-4">
                <!-- Main Dashboard Content -->
                <div class="col-12">
                    <div class="row g-4">
                        <!-- Sales Analytics Section -->
                        <div class="col-12 col-lg-8">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-transparent border-0 pb-0">
                                    <h5 class="mb-0 fw-bold">
                                        <i class="fas fa-chart-line me-2 text-primary"></i>
                                        Sales Analytics
                                    </h5>
                                </div>
                                <div class="card-body p-0">
                                    @livewire('dashboard.customer-sales-by-department')
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions & Tools -->
                        <div class="col-12 col-lg-4">
                            <div class="row g-4">
                                <!-- Quick Actions Card -->
                                <div class="col-12">
                                    <div class="card border-0 shadow-sm h-100">
                                        <div class="card-header bg-transparent border-0 pb-0">
                                            <h6 class="mb-0 fw-bold">
                                                <i class="fas fa-bolt me-2 text-warning"></i>
                                                Quick Actions
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="d-grid gap-2">
                                                <a href="{{ route('pricing') }}" class="btn btn-outline-primary btn-sm">
                                                    <i class="fas fa-calculator me-2"></i>Pricing Tools
                                                </a>
                                                <a href="{{ route('shipmentschedule') }}" class="btn btn-outline-success btn-sm">
                                                    <i class="fas fa-shipping-fast me-2"></i>Shipment Schedule
                                                </a>
                                                <a href="{{ route('criticalpath') }}" class="btn btn-outline-info btn-sm">
                                                    <i class="fas fa-project-diagram me-2"></i>Critical Path
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Recent Activity Card -->
                                <div class="col-12">
                                    <div class="card border-0 shadow-sm h-100">
                                        <div class="card-header bg-transparent border-0 pb-0">
                                            <h6 class="mb-0 fw-bold">
                                                <i class="fas fa-history me-2 text-info"></i>
                                                Recent Activity
                                            </h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="text-center text-muted py-4">
                                                <i class="fas fa-chart-bar fa-2x mb-2"></i>
                                                <p class="small mb-0">Activity feed coming soon</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Future Dashboard Sections - Placeholder for expansion -->
                <div class="col-12">
                    <div class="row g-4">
                        <!-- Production Overview Section -->
                        <div class="col-12 col-lg-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-transparent border-0 pb-0">
                                    <h5 class="mb-0 fw-bold">
                                        <i class="fas fa-cogs me-2 text-success"></i>
                                        Production Overview
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center text-muted py-5">
                                        <i class="fas fa-industry fa-3x mb-3"></i>
                                        <h6 class="text-muted">Production Dashboard</h6>
                                        <p class="small mb-0">Production metrics and status will appear here</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Financial Summary Section -->
                        <div class="col-12 col-lg-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-transparent border-0 pb-0">
                                    <h5 class="mb-0 fw-bold">
                                        <i class="fas fa-chart-pie me-2 text-warning"></i>
                                        Financial Summary
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center text-muted py-5">
                                        <i class="fas fa-dollar-sign fa-3x mb-3"></i>
                                        <h6 class="text-muted">Financial Dashboard</h6>
                                        <p class="small mb-0">Financial metrics and reports will appear here</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Additional Row for More Sections -->
                <div class="col-12">
                    <div class="row g-4">
                        <!-- Inventory Status Section -->
                        <div class="col-12 col-md-4">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-transparent border-0 pb-0">
                                    <h6 class="mb-0 fw-bold">
                                        <i class="fas fa-boxes me-2 text-info"></i>
                                        Inventory Status
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="text-center text-muted py-4">
                                        <i class="fas fa-warehouse fa-2x mb-2"></i>
                                        <p class="small mb-0">Inventory tracking coming soon</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Quality Control Section -->
                        <div class="col-12 col-md-4">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-transparent border-0 pb-0">
                                    <h6 class="mb-0 fw-bold">
                                        <i class="fas fa-check-circle me-2 text-success"></i>
                                        Quality Control
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="text-center text-muted py-4">
                                        <i class="fas fa-clipboard-check fa-2x mb-2"></i>
                                        <p class="small mb-0">Quality metrics coming soon</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Team Performance Section -->
                        <div class="col-12 col-md-4">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-transparent border-0 pb-0">
                                    <h6 class="mb-0 fw-bold">
                                        <i class="fas fa-users me-2 text-primary"></i>
                                        Team Performance
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="text-center text-muted py-4">
                                        <i class="fas fa-user-chart fa-2x mb-2"></i>
                                        <p class="small mb-0">Team analytics coming soon</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function refreshDashboard() {
            // Refresh all Livewire components
            Livewire.emit('refreshData');
        }

        function exportDashboard() {
            // Export functionality
            alert('Export functionality coming soon');
        }

        // Update quick stats when component loads
        document.addEventListener('livewire:load', function () {
            Livewire.on('statsUpdated', (data) => {
                document.getElementById('total-sales').textContent = '£' + data.totalSales.toLocaleString();
                document.getElementById('pending-sales').textContent = '£' + data.pendingSales.toLocaleString();
                document.getElementById('total-customers').textContent = data.totalCustomers;
                document.getElementById('avg-progress').textContent = data.avgProgress + '%';
            });
        });
    </script>
</x-app-layout>
