<x-app-layout>
    <div id="page-content">
        <!-- Modern Dashboard Header -->
        <div class="bg-white border-bottom">
            <div class="px-4 py-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-tachometer-alt text-primary me-3 fs-2"></i>
                        <h1 class="fs-3 fw-bold text-dark mb-0">Dashboard</h1>
                    </div>
                    <div class="d-flex gap-2">
                        <button class="btn btn-outline-primary btn-sm" onclick="refreshDashboard()">
                            <i class="fas fa-sync-alt me-1"></i>Refresh All
                        </button>
                        <button class="btn btn-primary btn-sm" onclick="exportDashboard()">
                            <i class="fas fa-download me-1"></i>Export
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Full Width Dashboard Content -->
        <div class="p-4">
            <!-- Key Metrics Row -->
            <div class="row g-4 mb-4">
                <div class="col-12">
                    @livewire('dashboard.dashboard-metrics')
                </div>
            </div>

            <!-- Main Dashboard Grid -->
            <div class="row g-4">
                <!-- Customer Sales Progress - Full Width on Mobile, Half on Desktop -->
                <div class="col-12 col-xl-6">
                    <div class="h-100">
                        @livewire('dashboard.customer-sales-by-department')
                    </div>
                </div>

                <!-- Garments Due Chart - Full Width on Mobile, Half on Desktop -->
                <div class="col-12 col-xl-6">
                    <div class="h-100">
                        @livewire('dashboard.garments-due-chart')
                    </div>
                </div>
            </div>

            <!-- Additional Dashboard Sections -->
            <div class="row g-4 mt-2">
                <!-- Production Overview -->
                <div class="col-12 col-lg-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header bg-gradient bg-success text-white border-0">
                            <div class="d-flex align-items-center">
                                <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                                    <i class="fas fa-cogs fs-5"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-1 fw-bold">Production Overview</h5>
                                    <small class="text-white-75">Real-time production metrics</small>
                                </div>
                            </div>
                        </div>
                        <div class="card-body d-flex align-items-center justify-content-center" style="min-height: 200px;">
                            <div class="text-center text-muted">
                                <i class="fas fa-industry fa-3x mb-3"></i>
                                <h6 class="text-muted">Production Dashboard</h6>
                                <p class="small mb-0">Production metrics and status will appear here</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Financial Summary -->
                <div class="col-12 col-lg-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header bg-gradient bg-warning text-white border-0">
                            <div class="d-flex align-items-center">
                                <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                                    <i class="fas fa-chart-pie fs-5"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-1 fw-bold">Financial Summary</h5>
                                    <small class="text-white-75">Revenue and financial metrics</small>
                                </div>
                            </div>
                        </div>
                        <div class="card-body d-flex align-items-center justify-content-center" style="min-height: 200px;">
                            <div class="text-center text-muted">
                                <i class="fas fa-dollar-sign fa-3x mb-3"></i>
                                <h6 class="text-muted">Financial Dashboard</h6>
                                <p class="small mb-0">Financial metrics and reports will appear here</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Inventory Status -->
                <div class="col-12 col-lg-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-header bg-gradient bg-info text-white border-0">
                            <div class="d-flex align-items-center">
                                <div class="bg-white bg-opacity-20 rounded-circle p-2 me-3">
                                    <i class="fas fa-boxes fs-5"></i>
                                </div>
                                <div>
                                    <h5 class="card-title mb-1 fw-bold">Inventory Status</h5>
                                    <small class="text-white-75">Stock levels and alerts</small>
                                </div>
                            </div>
                        </div>
                        <div class="card-body d-flex align-items-center justify-content-center" style="min-height: 200px;">
                            <div class="text-center text-muted">
                                <i class="fas fa-warehouse fa-3x mb-3"></i>
                                <h6 class="text-muted">Inventory Dashboard</h6>
                                <p class="small mb-0">Inventory tracking coming soon</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function refreshDashboard() {
            // Refresh all Livewire components
            Livewire.emit('refreshData');
        }

        function exportDashboard() {
            // Export functionality
            alert('Export functionality coming soon');
        }

        // Update quick stats when component loads
        document.addEventListener('livewire:load', function () {
            Livewire.on('statsUpdated', (data) => {
                // Legacy stats handling - keeping for compatibility
                if (document.getElementById('total-sales')) {
                    document.getElementById('total-sales').textContent = '£' + data.totalSales.toLocaleString();
                }
                if (document.getElementById('pending-sales')) {
                    document.getElementById('pending-sales').textContent = '£' + data.pendingSales.toLocaleString();
                }
                if (document.getElementById('total-customers')) {
                    document.getElementById('total-customers').textContent = data.totalCustomers;
                }
                if (document.getElementById('avg-progress')) {
                    document.getElementById('avg-progress').textContent = data.avgProgress + '%';
                }
            });
        });
    </script>
</x-app-layout>