<x-app-layout>
    <div id="page-content">
        <!-- Modern Dashboard Header -->
        <div class="bg-white border-bottom">
            <div class="px-4 py-3">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-tachometer-alt text-primary me-3 fs-2"></i>
                        <h1 class="fs-3 fw-bold text-dark mb-0">Dashboard</h1>
                    </div>
                    <div class="d-flex gap-2">
                        <button class="btn btn-outline-primary btn-sm" onclick="refreshDashboard()">
                            <i class="fas fa-sync-alt me-1"></i>Refresh All
                        </button>
                        <button class="btn btn-primary btn-sm" onclick="exportDashboard()">
                            <i class="fas fa-download me-1"></i>Export
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Full Width Dashboard Content -->
        <div class="p-4">
            <!-- Key Metrics Row -->
            <div class="row g-4 mb-4">
                <div class="col-12">
                    @livewire('dashboard.dashboard-metrics')
                </div>
            </div>

            <!-- Main Dashboard Grid -->
            <div class="row g-4">
                <!-- Customer Sales Progress - Full Width on Mobile, Half on Desktop -->
                <div class="col-12 col-xl-6">
                    <div class="h-100">
                        @livewire('dashboard.customer-sales-by-department')
                    </div>
                </div>

                <!-- Garments Due Chart - Full Width on Mobile, Half on Desktop -->
                <div class="col-12 col-xl-6">
                    <div class="h-100">
                        @livewire('dashboard.garments-due-chart')
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        function refreshDashboard() {
            // Refresh all Livewire components
            Livewire.emit('refreshData');
        }

        function exportDashboard() {
            // Export functionality
            alert('Export functionality coming soon');
        }

        // Update quick stats when component loads
        document.addEventListener('livewire:load', function () {
            Livewire.on('statsUpdated', (data) => {
                // Legacy stats handling - keeping for compatibility
                if (document.getElementById('total-sales')) {
                    document.getElementById('total-sales').textContent = '£' + data.totalSales.toLocaleString();
                }
                if (document.getElementById('pending-sales')) {
                    document.getElementById('pending-sales').textContent = '£' + data.pendingSales.toLocaleString();
                }
                if (document.getElementById('total-customers')) {
                    document.getElementById('total-customers').textContent = data.totalCustomers;
                }
                if (document.getElementById('avg-progress')) {
                    document.getElementById('avg-progress').textContent = data.avgProgress + '%';
                }
            });
        });
    </script>
</x-app-layout>