<x-app-layout>
    <div id="page-content">
        <!-- Dashboard Filters -->
        @livewire('dashboard.dashboard-filters')

        <!-- Full Width Dashboard Content -->
        <div class="p-4">
            <!-- Key Metrics Row -->
            <div class="row g-4 mb-4">
                <div class="col-12">
                    @livewire('dashboard.dashboard-metrics')
                </div>
            </div>

            <!-- Main Dashboard Grid -->
            <div class="row g-4">
                <!-- Customer Sales Progress - Full Width on Mobile, Half on Desktop -->
                <div class="col-12 col-xl-6">
                    <div class="h-100">
                        @livewire('dashboard.customer-sales-by-department')
                    </div>
                </div>

                <!-- Garments Due Chart - Full Width on Mobile, Half on Desktop -->
                <div class="col-12 col-xl-6">
                    <div class="h-100">
                        @livewire('dashboard.garments-due-chart')
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        // Update quick stats when component loads
        document.addEventListener('livewire:load', function () {
            Livewire.on('statsUpdated', (data) => {
                // Legacy stats handling - keeping for compatibility
                if (document.getElementById('total-sales')) {
                    document.getElementById('total-sales').textContent = '£' + data.totalSales.toLocaleString();
                }
                if (document.getElementById('pending-sales')) {
                    document.getElementById('pending-sales').textContent = '£' + data.pendingSales.toLocaleString();
                }
                if (document.getElementById('total-customers')) {
                    document.getElementById('total-customers').textContent = data.totalCustomers;
                }
                if (document.getElementById('avg-progress')) {
                    document.getElementById('avg-progress').textContent = data.avgProgress + '%';
                }
            });
        });
    </script>
</x-app-layout>