<?php
$meta = [
  'title' => 'About | Neil Widdowson',
  'description' => 'Hi, I\'m Neil. Local IT and website help for small businesses in Newcastle and the North East.',
  'canonical' => 'https://neilwiddowson.co.uk/about/'
];
$currentPage = 'about';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container">
    <!-- Hero Section -->
    <div class="grid gap-8 lg:grid-cols-3 lg:items-start lg:gap-12">
      <!-- Content -->
      <div class="lg:col-span-2">
        <div class="relative">
          <div class="blob bg-accent-500/40 -z-10 w-32 h-32 -top-4 -left-6" data-parallax="0.08"></div>
          <h1 class="text-4xl sm:text-5xl lg:text-6xl font-bold tracking-tight text-gray-900">
            Hi, I'm <span class="accent-underline">Neil</span>.
          </h1>
        </div>
        
        <div class="mt-6 space-y-4">
          <p class="text-lg sm:text-xl text-gray-700 leading-relaxed">
            I've worked in IT and websites for years, helping North East small businesses stay online and look good doing it. 
            <span class="font-medium text-gray-900">I'm local, responsive, and I keep things simple.</span>
          </p>
          <p class="text-gray-700 leading-relaxed">
            Whether it's fixing email and Wi‑Fi, or building a clear, fast website on Joomla, my goal is to help you get more enquiries without the faff.
          </p>
        </div>
        
        <!-- CTA Buttons -->
        <div class="mt-8 flex flex-col sm:flex-row gap-4">
          <a href="/portfolio/" class="btn-secondary text-center sm:text-left">View portfolio</a>
          <a href="/contact/" class="btn-primary text-center sm:text-left">Get a free quote</a>
        </div>
      </div>
      
      <!-- Photo -->
      <aside class="lg:order-first">
        <div class="card p-6">
          <div class="relative">
            <img src="/img/neil-placeholder.webp" width="560" height="700" alt="Photo of Neil" class="w-full rounded-xl object-cover aspect-[4/5]" loading="lazy">
            <div class="absolute inset-0 rounded-xl bg-gradient-to-t from-black/20 to-transparent"></div>
          </div>
          <!-- TODO: Replace with a real photo -->
        </div>
      </aside>
    </div>
    
    <!-- Credentials Section -->
    <section class="mt-16 lg:mt-20">
      <div class="relative">
        <div class="blob bg-accent-500/40 -z-10 w-40 h-40 -top-6 right-0" data-parallax="0.06"></div>
        <h2 class="text-2xl sm:text-3xl font-semibold text-gray-900">
          <span class="accent-underline">Credentials & timeline</span>
        </h2>
      </div>
      
      <div class="mt-8 grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
        <div class="card p-6">
          <div class="flex items-start gap-4">
            <div class="flex-shrink-0 w-12 h-12 bg-accent-100 rounded-lg flex items-center justify-center">
              <svg class="w-6 h-6 text-accent-600" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
              </svg>
            </div>
            <div>
              <h3 class="font-semibold text-gray-900 mb-2">10+ Years Experience</h3>
              <p class="text-sm text-gray-700">Supporting small businesses in the North East with reliable IT solutions and clear communication.</p>
            </div>
          </div>
        </div>
        
        <div class="card p-6">
          <div class="flex items-start gap-4">
            <div class="flex-shrink-0 w-12 h-12 bg-accent-100 rounded-lg flex items-center justify-center">
              <svg class="w-6 h-6 text-accent-600" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
              </svg>
            </div>
            <div>
              <h3 class="font-semibold text-gray-900 mb-2">Joomla Specialist</h3>
              <p class="text-sm text-gray-700">Expert in Joomla development. Happy to support WordPress and Wix migrations to better platforms.</p>
            </div>
          </div>
        </div>
        
        <div class="card p-6 sm:col-span-2 lg:col-span-1">
          <div class="flex items-start gap-4">
            <div class="flex-shrink-0 w-12 h-12 bg-accent-100 rounded-lg flex items-center justify-center">
              <svg class="w-6 h-6 text-accent-600" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
              </svg>
            </div>
            <div>
              <h3 class="font-semibold text-gray-900 mb-2">Plain English</h3>
              <p class="text-sm text-gray-700">Practical, jargon-free approach that makes technology accessible and understandable for everyone.</p>
            </div>
          </div>
        </div>
      </div>
    </section>
    
    <!-- Values Section -->
    <section class="mt-16 lg:mt-20">
      <div class="text-center">
        <h2 class="text-2xl sm:text-3xl font-semibold text-gray-900 mb-4">
          <span class="accent-underline">What I believe</span>
        </h2>
        <p class="text-lg text-gray-700 max-w-3xl mx-auto">
          Technology should work for you, not against you. Every solution I provide is designed to be simple, reliable, and focused on helping your business grow.
        </p>
      </div>
      
      <div class="mt-12 grid gap-8 sm:grid-cols-2 lg:grid-cols-4">
        <div class="text-center">
          <div class="w-16 h-16 bg-accent-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <svg class="w-8 h-8 text-accent-600" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
            </svg>
          </div>
          <h3 class="font-semibold text-gray-900 mb-2">Reliable</h3>
          <p class="text-sm text-gray-700">Solutions that work consistently, day in and day out.</p>
        </div>
        
        <div class="text-center">
          <div class="w-16 h-16 bg-accent-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <svg class="w-8 h-8 text-accent-600" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
            </svg>
          </div>
          <h3 class="font-semibold text-gray-900 mb-2">Simple</h3>
          <p class="text-sm text-gray-700">Clear, straightforward solutions without unnecessary complexity.</p>
        </div>
        
        <div class="text-center">
          <div class="w-16 h-16 bg-accent-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <svg class="w-8 h-8 text-accent-600" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-8.293l-3-3a1 1 0 00-1.414 0l-3 3a1 1 0 001.414 1.414L9 9.414V13a1 1 0 102 0V9.414l1.293 1.293a1 1 0 001.414-1.414z" clip-rule="evenodd"></path>
            </svg>
          </div>
          <h3 class="font-semibold text-gray-900 mb-2">Local</h3>
          <p class="text-sm text-gray-700">Based in Newcastle, understanding local business needs.</p>
        </div>
        
        <div class="text-center">
          <div class="w-16 h-16 bg-accent-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <svg class="w-8 h-8 text-accent-600" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
            </svg>
          </div>
          <h3 class="font-semibold text-gray-900 mb-2">Responsive</h3>
          <p class="text-sm text-gray-700">Quick to respond and adapt to your changing needs.</p>
        </div>
      </div>
    </section>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
