<?php
$meta = [
  'title' => 'About | Neil Widdowson',
  'description' => 'Hi, I\'m Neil. Local IT and website help for small businesses in Newcastle and the North East.',
  'canonical' => 'https://neilwiddowson.co.uk/about/'
];
$currentPage = 'about';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container grid gap-10 lg:grid-cols-3 lg:items-start">
    <div class="lg:col-span-2">
      <h1 class="text-3xl font-bold tracking-tight">Hi, I'm Neil.</h1>
      <p class="mt-4 text-lg text-gray-700">I've worked in IT and websites for years, helping North East small businesses stay online and look good doing it. I'm local, responsive, and I keep things simple.</p>
      <p class="mt-4 text-gray-700">Whether it's fixing email and Wi‑Fi, or building a clear, fast website on Joomla, my goal is to help you get more enquiries without the faff.</p>
      <div class="mt-6">
        <a href="/portfolio/" class="btn-secondary">View portfolio</a>
        <a href="/contact/" class="btn-primary ml-2">Get a free quote</a>
      </div>
      <section class="mt-10">
        <h2 class="text-xl font-semibold">Credentials & timeline</h2>
        <ul class="mt-4 space-y-3 text-sm text-gray-700">
          <li>Over 10 years supporting small businesses in the North East</li>
          <li>Joomla specialist; happy to support WordPress/Wix migrations</li>
          <li>Practical, plain‑English approach</li>
        </ul>
      </section>
    </div>
    <aside>
      <div class="card p-4">
        <img src="/img/neil-placeholder.webp" width="560" height="700" alt="Photo of Neil" class="rounded-xl object-cover aspect-[4/5]" loading="lazy">
        <!-- TODO: Replace with a real photo -->
      </div>
    </aside>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
