<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Season extends Model
{
    protected $fillable = [
        'code',
        'half',
        'year',
        'label',
        'description',
        'starts_on',
        'ends_on',
        'is_active',
    ];

    protected $casts = [
        'starts_on' => 'date',
        'ends_on' => 'date',
        'is_active' => 'boolean',
    ];

    /**
     * Get the items for this season.
     */
    public function items(): HasMany
    {
        return $this->hasMany(Item::class);
    }

    /**
     * Scope a query to only include active seasons.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope a query to only include seasons by half.
     */
    public function scopeByHalf($query, $half)
    {
        return $query->where('half', $half);
    }

    /**
     * Scope a query to only include seasons by year.
     */
    public function scopeByYear($query, $year)
    {
        return $query->where('year', $year);
    }
}
