<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('receipts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('statement_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('matched_transaction_id')->nullable()->constrained('statement_transactions')->nullOnDelete();
            $table->date('receipt_date')->index();
            $table->decimal('total_amount', 12, 2);
            $table->string('currency', 8)->default('GBP');
            $table->string('vendor_name')->nullable();
            $table->boolean('is_personal')->default(false);
            $table->string('storage_path');
            $table->string('department')->nullable();
            $table->string('account_code')->nullable();
            $table->decimal('vat_total', 12, 2)->nullable();
            $table->json('vat_analysis')->nullable();
            $table->enum('status', ['uploaded', 'matched', 'review_pending', 'approved'])->default('uploaded');
            $table->timestamps();

            $table->index(['receipt_date', 'total_amount']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('receipts');
    }
};


