@extends('layouts.shop')

@section('title', 'About Us - Yarn Store')
@section('meta_description', 'Learn about Yarn Store and Robert Todd Yarn. Premium quality yarns for knitting and crochet enthusiasts since [year].')

@section('content')
<div class="py-5 text-center" style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-light) 100%); color: white;">
    <div class="container">
        <h1 class="display-4 fw-bold mb-3">About Yarn Store</h1>
        <p class="lead">Premium yarns for passionate crafters</p>
    </div>
</div>

<div class="container py-5">
    <div class="row mb-5">
        <div class="col-lg-6 mb-4 mb-lg-0">
            <h2 class="fw-bold mb-3">Our Story</h2>
            <p>Founded by Robert Todd, Yarn Store has been dedicated to bringing the finest quality yarns to crafters across the UK and beyond. What started as a passion for quality yarns has grown into a trusted source for knitters and crocheters who demand the best.</p>
            <p>We carefully curate our collection, selecting only the finest yarns from renowned suppliers worldwide. Each yarn is chosen for its quality, texture, and the joy it brings to your creative projects.</p>
        </div>
        <div class="col-lg-6">
            <div class="p-4 rounded" style="background-color: var(--ys-bg-section);">
                <h3 class="fw-bold mb-3">Our Values</h3>
                <ul class="list-unstyled">
                    <li class="mb-3">
                        <strong style="color: var(--ys-primary);">✓ Quality First:</strong> We never compromise on quality
                    </li>
                    <li class="mb-3">
                        <strong style="color: var(--ys-primary);">✓ Customer Service:</strong> Your satisfaction is our priority
                    </li>
                    <li class="mb-3">
                        <strong style="color: var(--ys-primary);">✓ Sustainability:</strong> Supporting ethical and sustainable practices
                    </li>
                    <li class="mb-3">
                        <strong style="color: var(--ys-primary);">✓ Community:</strong> Supporting the crafting community
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-12">
            <h2 class="fw-bold mb-4 text-center">Why Choose Yarn Store?</h2>
        </div>
        <div class="col-md-4 mb-4">
            <div class="ys-card p-4 text-center h-100">
                <div class="mb-3" style="color: var(--ys-primary);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M12 2L2 7l10 5 10-5-10-5z"></path>
                        <path d="M2 17l10 5 10-5"></path>
                        <path d="M2 12l10 5 10-5"></path>
                    </svg>
                </div>
                <h4 class="fw-bold mb-2">Curated Selection</h4>
                <p class="text-muted">Every yarn in our collection is hand-selected for quality and performance</p>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="ys-card p-4 text-center h-100">
                <div class="mb-3" style="color: var(--ys-primary);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                        <circle cx="9" cy="7" r="4"></circle>
                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                    </svg>
                </div>
                <h4 class="fw-bold mb-2">Expert Support</h4>
                <p class="text-muted">Our team is here to help you find the perfect yarn for your project</p>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="ys-card p-4 text-center h-100">
                <div class="mb-3" style="color: var(--ys-primary);">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                        <circle cx="12" cy="10" r="3"></circle>
                    </svg>
                </div>
                <h4 class="fw-bold mb-2">Delivered Direct from Our Spinners</h4>
                <p class="text-muted">All yarn is delivered to order from our spinners, all over the world. Everything is spun to order.</p>
            </div>
        </div>
    </div>

    <div class="text-center py-5" style="background-color: var(--ys-bg-section); border-radius: 0.5rem;">
        <h2 class="fw-bold mb-3">Ready to Start Your Next Project?</h2>
        <p class="text-muted mb-4">Browse our collection of premium yarns</p>
        <a href="{{ route('shop.all') }}" class="btn btn-ys-primary btn-lg">
            Shop Now
        </a>
    </div>
</div>
@endsection



