<nav x-data="{ open: false }" class="bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <div class="shrink-0 flex items-center">
                    <a href="/dashboard" class="font-semibold">ExpenseWise</a>
                </div>

                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                        {{ __('Dashboard') }}
                    </x-nav-link>
                    @role('finance')
                        <x-nav-link :href="route('finance.statements.import')" :active="request()->routeIs('finance.statements.*')">
                            {{ __('Import Statement') }}
                        </x-nav-link>
                    @endrole
                    @hasanyrole('finance|user')
                        <x-nav-link :href="route('user.receipts.upload')" :active="request()->routeIs('user.receipts.*')">
                            {{ __('Upload Receipt') }}
                        </x-nav-link>
                    @endhasanyrole
                </div>
            </div>
        </div>
    </div>
</nav>
