<?php

use App\Livewire\Actions\Logout;
use Livewire\Volt\Component;

new class extends Component
{
    /**
     * Log the current user out of the application.
     */
    public function logout(Logout $logout): void
    {
        $logout();

        $this->redirect('/', navigate: true);
    }
}; ?>

<nav class="space-y-2 h-full flex flex-col">
    <!-- Navigation Links -->
    <div class="space-y-1 flex-1">
        <a href="{{ route('dashboard') }}" wire:navigate class="sidebar-item-icon {{ request()->routeIs('dashboard') ? 'sidebar-item-active' : '' }}" title="Dashboard">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v6H8V5z"></path>
            </svg>
        </a>
        
        @hasanyrole('finance|user')
            <a href="{{ route('manage') }}" wire:navigate class="sidebar-item-icon {{ request()->routeIs('manage') ? 'sidebar-item-active' : '' }}" title="Manage">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
            </a>
        @endhasanyrole
        
        @role('finance')
            <a href="{{ route('finance.statements.index') }}" wire:navigate class="sidebar-item-icon {{ request()->routeIs('finance.statements.index') ? 'sidebar-item-active' : '' }}" title="Statements">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
            </a>
            
            <a href="{{ route('finance.statements.import') }}" wire:navigate class="sidebar-item-icon {{ request()->routeIs('finance.statements.import') ? 'sidebar-item-active' : '' }}" title="Import">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M9 19l3 3m0 0l3-3m-3 3V10"></path>
                </svg>
            </a>
        @endrole
        
        @hasanyrole('finance|user')
            <a href="{{ route('user.receipts.index') }}" wire:navigate class="sidebar-item-icon {{ request()->routeIs('user.receipts.index') ? 'sidebar-item-active' : '' }}" title="Receipts">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
            </a>
            
            <a href="{{ route('user.receipts.upload') }}" wire:navigate class="sidebar-item-icon {{ request()->routeIs('user.receipts.upload') ? 'sidebar-item-active' : '' }}" title="Upload">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                </svg>
            </a>
        @endhasanyrole
    </div>

    <!-- User Section - Bottom -->
    <div class="border-t border-border-light dark:border-border-dark pt-2">
        <div class="space-y-1">
            <a href="{{ route('profile') }}" wire:navigate class="sidebar-item-icon" title="Profile">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                </svg>
            </a>
            
            <button wire:click="logout" class="sidebar-item-icon w-full" title="Sign Out">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                </svg>
            </button>
        </div>
    </div>
</nav>
