<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Request Custom Session') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="mb-6">
                        <h3 class="text-lg font-medium text-gray-900">Create Your Personalized Session</h3>
                        <p class="mt-1 text-sm text-gray-500">
                            Tell us about your goals and preferences, and our AI will create a custom hypnosis session just for you.
                        </p>
                    </div>

                    <form method="POST" action="#" class="space-y-6">
                        @csrf
                        
                        <!-- Topic/Goal -->
                        <div>
                            <label for="topic" class="block text-sm font-medium text-gray-700">
                                What would you like to work on? *
                            </label>
                            <textarea
                                id="topic"
                                name="topic"
                                rows="4"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                placeholder="e.g., I want to improve my sleep quality and fall asleep faster. I often feel anxious at bedtime and have trouble quieting my mind..."
                                required
                            ></textarea>
                            <p class="mt-2 text-sm text-gray-500">
                                Be specific about your goals, challenges, and what you hope to achieve.
                            </p>
                        </div>

                        <!-- Session Length -->
                        <div>
                            <label for="length" class="block text-sm font-medium text-gray-700">
                                Preferred Session Length *
                            </label>
                            <select
                                id="length"
                                name="length"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                required
                            >
                                <option value="">Select length</option>
                                <option value="10">10 minutes - Quick relaxation</option>
                                <option value="15">15 minutes - Standard session</option>
                                <option value="20">20 minutes - Deep work</option>
                                <option value="30">30 minutes - Extended session</option>
                            </select>
                        </div>

                        <!-- Voice Preferences -->
                        <div>
                            <label for="voice" class="block text-sm font-medium text-gray-700">
                                Voice Preference
                            </label>
                            <select
                                id="voice"
                                name="voice"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                            >
                                <option value="">No preference</option>
                                <option value="calm">Calm and soothing</option>
                                <option value="confident">Confident and authoritative</option>
                                <option value="gentle">Gentle and nurturing</option>
                                <option value="energetic">Energetic and motivating</option>
                            </select>
                        </div>

                        <!-- Additional Context -->
                        <div>
                            <label for="context" class="block text-sm font-medium text-gray-700">
                                Additional Context (Optional)
                            </label>
                            <textarea
                                id="context"
                                name="context"
                                rows="3"
                                class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                                placeholder="Any other details that might help personalize your session..."
                            ></textarea>
                        </div>

                        <!-- Submit Button -->
                        <div class="flex items-center justify-end">
                            <button
                                type="submit"
                                class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 focus:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150"
                            >
                                Create Session
                            </button>
                        </div>
                    </form>

                    <!-- Info Box -->
                    <div class="mt-8 bg-blue-50 border border-blue-200 rounded-md p-4">
                        <div class="flex">
                            <div class="flex-shrink-0">
                                <svg class="h-5 w-5 text-blue-400" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                                </svg>
                            </div>
                            <div class="ml-3">
                                <h3 class="text-sm font-medium text-blue-800">
                                    What happens next?
                                </h3>
                                <div class="mt-2 text-sm text-blue-700">
                                    <p>Your request will be processed by our AI system. You'll receive a notification when your custom session is ready, typically within 24 hours.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
