<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transaction_matches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('statement_transaction_id')->constrained('statement_transactions')->cascadeOnDelete();
            $table->foreignId('receipt_id')->constrained('receipts')->cascadeOnDelete();
            $table->decimal('matched_amount', 12, 2);
            $table->enum('match_method', ['rule', 'llm', 'match'])->default('rule');
            $table->decimal('amount_confidence', 5, 2)->nullable();
            $table->decimal('date_confidence', 5, 2)->nullable();
            $table->decimal('merchant_confidence', 5, 2)->nullable();
            $table->text('explanation')->nullable();
            $table->timestamps();
            $table->unique(['statement_transaction_id', 'receipt_id'], 'unique_stmt_txn_receipt');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transaction_matches');
    }
};
