<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('receipts', function (Blueprint $table) {
            $table->foreignId('receipt_group_id')->nullable()->after('account_id')->constrained('receipt_groups')->nullOnDelete();
            $table->index(['receipt_group_id', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('receipts', function (Blueprint $table) {
            $table->dropForeign(['receipt_group_id']);
            $table->dropIndex(['receipt_group_id', 'created_at']);
            $table->dropColumn('receipt_group_id');
        });
    }
};