<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CustomSession extends Model
{
    use HasFactory;

    protected $fillable = [
        'custom_request_id',
        'user_id',
        'title',
        'description',
        'file_path',
        'transcript',
        'duration',
        'status',
        'generation_metadata',
        'generated_at',
    ];

    protected $casts = [
        'generation_metadata' => 'array',
        'generated_at' => 'datetime',
    ];

    public function customRequest(): BelongsTo
    {
        return $this->belongsTo(CustomRequest::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function scopeByStatus($query, $status)
    {
        return $query->where('status', $status);
    }

    public function scopeByUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function isQueued(): bool
    {
        return $this->status === 'queued';
    }

    public function isGenerating(): bool
    {
        return $this->status === 'generating';
    }

    public function isReady(): bool
    {
        return $this->status === 'ready';
    }

    public function isFailed(): bool
    {
        return $this->status === 'failed';
    }
}
